"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkMuteUnmuteInstances = bulkMuteUnmuteInstances;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _rule = require("../../../../data/rule");
var _common = require("../../../../rules_client/common");
var _transform_bulk_mute_unmute_rules_to_alert_instances = require("../../transforms/transform_bulk_mute_unmute_rules_to_alert_instances");
var _saved_objects = require("../../../../saved_objects");
var _bulk_mute_unmute_schema = require("../../schemas/bulk_mute_unmute_schema");
var _authorization = require("../../../../authorization");
var _audit_events = require("../../../../rules_client/common/audit_events");
var _transform_rule_mute_instance_ids = require("./transforms/transform_rule_mute_instance_ids");
var _transform_rule_unmute_instance_ids = require("./transforms/transform_rule_unmute_instance_ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function bulkMuteUnmuteInstances(context, {
  params,
  mute
}) {
  try {
    _bulk_mute_unmute_schema.bulkMuteUnmuteAlertsParamsSchema.validate(params);
  } catch (error) {
    throw _boom.default.badRequest(`Failed to validate params: ${error.message}`);
  }
  await (0, _common.retryIfBulkEditConflicts)(context.logger, `rulesClient.bulkMuteUnmuteInstances('${JSON.stringify(params)}', ${mute})`, async () => await bulkMuteUnmuteInstancesWithOCC(context, {
    params,
    mute
  }));
}
const EMPTY_RESULT = {
  apiKeysToInvalidate: [],
  resultSavedObjects: [],
  errors: [],
  rules: [],
  skipped: []
};
async function bulkMuteUnmuteInstancesWithOCC(context, {
  params,
  mute
}) {
  var _bulkUpdateRes$saved_;
  let bulkUpdateRes;
  if (params.rules.length === 0) {
    return EMPTY_RESULT;
  }
  const rules = await (0, _rule.bulkGetRulesSo)({
    savedObjectsClient: context.unsecuredSavedObjectsClient,
    ids: params.rules.map(p => p.id)
  });
  try {
    const rulesSavedObjects = [];
    const ruleTypeIdConsumersPairs = [];
    const ruleTypeIds = new Set();
    if (rules.saved_objects.length === 0) {
      throw _boom.default.badRequest(`Rules not found: ${JSON.stringify(params.rules.map(r => r.id))}`);
    }
    rules.saved_objects.forEach(rule => {
      if (rule.error) {
        return;
      }
      rulesSavedObjects.push(rule);
      ruleTypeIds.add(rule.attributes.alertTypeId);
      ruleTypeIdConsumersPairs.push({
        ruleTypeId: rule.attributes.alertTypeId,
        consumers: [rule.attributes.consumer]
      });
    });
    const indices = context.getAlertIndicesAlias(Array.from(ruleTypeIds), context.spaceId);
    await context.authorization.bulkEnsureAuthorized({
      ruleTypeIdConsumersPairs,
      operation: mute ? _authorization.WriteOperations.MuteAlert : _authorization.WriteOperations.UnmuteAlert,
      entity: _authorization.AlertingAuthorizationEntity.Rule
    });
    const action = mute ? _audit_events.RuleAuditAction.BULK_MUTE_ALERTS : _audit_events.RuleAuditAction.BULK_UNMUTE_ALERTS;
    for (const rule of rulesSavedObjects) {
      var _context$auditLogger;
      (_context$auditLogger = context.auditLogger) === null || _context$auditLogger === void 0 ? void 0 : _context$auditLogger.log((0, _audit_events.ruleAuditEvent)({
        action,
        outcome: 'unknown',
        savedObject: {
          type: _saved_objects.RULE_SAVED_OBJECT_TYPE,
          id: rule.id,
          name: rule.attributes.name
        }
      }));
    }
    const rulesToUpdate = mute ? (0, _transform_rule_mute_instance_ids.transformMuteRequestToRuleAttributes)({
      savedRules: rulesSavedObjects,
      paramRules: params.rules
    }) : (0, _transform_rule_unmute_instance_ids.transformUnmuteRequestToRuleAttributes)({
      savedRules: rulesSavedObjects,
      paramRules: params.rules
    });
    bulkUpdateRes = await (0, _rule.bulkUpdateRuleSo)({
      savedObjectsClient: context.unsecuredSavedObjectsClient,
      rules: rulesToUpdate
    });
    if (indices && indices.length > 0) {
      const options = {
        targets: (0, _transform_bulk_mute_unmute_rules_to_alert_instances.transformParamsRulesToAlertInstances)(params.rules),
        indices,
        logger: context.logger
      };
      if (mute) {
        var _context$alertsServic;
        await ((_context$alertsServic = context.alertsService) === null || _context$alertsServic === void 0 ? void 0 : _context$alertsServic.muteAlertInstances(options));
      } else {
        var _context$alertsServic2;
        await ((_context$alertsServic2 = context.alertsService) === null || _context$alertsServic2 === void 0 ? void 0 : _context$alertsServic2.unmuteAlertInstances(options));
      }
    }
  } catch (error) {
    var _context$auditLogger2;
    const action = mute ? _audit_events.RuleAuditAction.BULK_MUTE_ALERTS : _audit_events.RuleAuditAction.BULK_UNMUTE_ALERTS;
    (_context$auditLogger2 = context.auditLogger) === null || _context$auditLogger2 === void 0 ? void 0 : _context$auditLogger2.log((0, _audit_events.ruleAuditEvent)({
      action,
      error
    }));
    const alertAction = mute ? 'muting' : 'unmuting';
    context.logger.error(`Error while bulk ${alertAction} alerts: ${error.message}`);
    throw error;
  }
  return {
    apiKeysToInvalidate: [],
    resultSavedObjects: (_bulkUpdateRes$saved_ = bulkUpdateRes.saved_objects) !== null && _bulkUpdateRes$saved_ !== void 0 ? _bulkUpdateRes$saved_ : [],
    errors: [],
    rules: [],
    skipped: []
  };
}