"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatGapAutoFillSchedulerLogEntry = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatGapAutoFillSchedulerLogEntry = entry => {
  var _entry$kibana, _entry$kibana$gap_aut, _execution$results;
  const execution = (_entry$kibana = entry.kibana) === null || _entry$kibana === void 0 ? void 0 : (_entry$kibana$gap_aut = _entry$kibana.gap_auto_fill) === null || _entry$kibana$gap_aut === void 0 ? void 0 : _entry$kibana$gap_aut.execution;
  const executionResults = (_execution$results = execution === null || execution === void 0 ? void 0 : execution.results) !== null && _execution$results !== void 0 ? _execution$results : [];
  return {
    id: entry._id,
    timestamp: entry['@timestamp'],
    status: execution === null || execution === void 0 ? void 0 : execution.status,
    message: entry.message,
    results: executionResults === null || executionResults === void 0 ? void 0 : executionResults.map(resultItem => ({
      ruleId: resultItem.rule_id,
      processedGaps: resultItem.processed_gaps ? Number(resultItem.processed_gaps) : undefined,
      status: resultItem.status,
      error: resultItem.error
    }))
  };
};
exports.formatGapAutoFillSchedulerLogEntry = formatGapAutoFillSchedulerLogEntry;