"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.gapAutoFillSchedulerLogsResultSchema = exports.gapAutoFillSchedulerLogEntrySchema = exports.findGapAutoFillSchedulerLogsParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findGapAutoFillSchedulerLogsParamsSchema = exports.findGapAutoFillSchedulerLogsParamsSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  start: _configSchema.schema.string(),
  end: _configSchema.schema.string(),
  page: _configSchema.schema.number({
    defaultValue: 1,
    min: 1
  }),
  perPage: _configSchema.schema.number({
    defaultValue: 50,
    min: 1,
    max: 100
  }),
  sortField: _configSchema.schema.oneOf([_configSchema.schema.literal('@timestamp')], {
    defaultValue: '@timestamp'
  }),
  sortDirection: _configSchema.schema.oneOf([_configSchema.schema.literal('asc'), _configSchema.schema.literal('desc')], {
    defaultValue: 'desc'
  }),
  statuses: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal('success'), _configSchema.schema.literal('error'), _configSchema.schema.literal('skipped'), _configSchema.schema.literal('no_gaps')])))
});
const gapAutoFillSchedulerLogEntrySchema = exports.gapAutoFillSchedulerLogEntrySchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  timestamp: _configSchema.schema.maybe(_configSchema.schema.string()),
  status: _configSchema.schema.maybe(_configSchema.schema.string()),
  message: _configSchema.schema.maybe(_configSchema.schema.string()),
  results: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    ruleId: _configSchema.schema.maybe(_configSchema.schema.string()),
    processedGaps: _configSchema.schema.maybe(_configSchema.schema.number()),
    status: _configSchema.schema.maybe(_configSchema.schema.string()),
    error: _configSchema.schema.maybe(_configSchema.schema.string())
  })))
});
const gapAutoFillSchedulerLogsResultSchema = exports.gapAutoFillSchedulerLogsResultSchema = _configSchema.schema.object({
  data: _configSchema.schema.arrayOf(gapAutoFillSchedulerLogEntrySchema),
  total: _configSchema.schema.number(),
  page: _configSchema.schema.number(),
  perPage: _configSchema.schema.number()
});