"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isAlertImproving = void 0;
var _lodash = require("lodash");
var _ruleDataUtils = require("@kbn/rule-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isAlertImproving = (alert, legacyAlert, actionGroups) => {
  var _legacyAlert$getSched;
  const currentActionGroup = (_legacyAlert$getSched = legacyAlert.getScheduledActionOptions()) === null || _legacyAlert$getSched === void 0 ? void 0 : _legacyAlert$getSched.actionGroup;
  const previousActionGroup = (0, _lodash.get)(alert, _ruleDataUtils.ALERT_ACTION_GROUP);
  if (!currentActionGroup || !previousActionGroup) {
    return null;
  }

  // Get action group definitions
  const currentActionGroupDef = actionGroups.find(ag => ag.id === currentActionGroup);
  const previousActionGroupDef = actionGroups.find(ag => ag.id === previousActionGroup);
  if (currentActionGroupDef && previousActionGroupDef && currentActionGroupDef.severity && previousActionGroupDef.severity) {
    const toRet = currentActionGroupDef.severity.level === previousActionGroupDef.severity.level ? null : currentActionGroupDef.severity.level < previousActionGroupDef.severity.level;
    return toRet;
  }
  return null;
};
exports.isAlertImproving = isAlertImproving;