"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PartitionsSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _use_cancellable_search = require("../../hooks/use_cancellable_search");
var _use_data_source = require("../../hooks/use_data_source");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/change_point_detection/partitions_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getQueryPayload(indexPattern, fieldName, queryString = '', selectedPartitions) {
  return {
    params: {
      index: indexPattern,
      size: 0,
      ...(selectedPartitions !== null && selectedPartitions !== void 0 && selectedPartitions.length ? {
        query: {
          bool: {
            must_not: [{
              terms: {
                [fieldName]: selectedPartitions
              }
            }]
          }
        }
      } : {}),
      aggs: {
        aggResults: {
          filter: {
            bool: {
              must: {
                wildcard: {
                  [fieldName]: {
                    value: `*${queryString}*`
                  }
                }
              }
            }
          },
          aggs: {
            partitionValues: {
              terms: {
                field: fieldName
              }
            }
          }
        }
      }
    }
  };
}
const PartitionsSelector = ({
  value,
  onChange,
  splitField,
  enableSearch = true
}) => {
  const {
    dataView
  } = (0, _use_data_source.useDataSource)();
  const {
    notifications: {
      toasts
    }
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const prevSplitField = (0, _usePrevious.default)(splitField);
  const [options, setOptions] = (0, _react.useState)([]);
  const [isLoading, setIsLoading] = (0, _react.useState)(enableSearch);
  const {
    runRequest,
    cancelRequest
  } = (0, _use_cancellable_search.useCancellableSearch)();
  const fetchResults = (0, _react.useCallback)(async searchValue => {
    if (!enableSearch) return;
    cancelRequest();
    setIsLoading(true);
    try {
      const requestPayload = getQueryPayload(dataView.getIndexPattern(), splitField, searchValue, value);
      const result = await runRequest(requestPayload);
      if (result === null) {
        setOptions([]);
        return;
      }
      setOptions(result.rawResponse.aggregations.aggResults.partitionValues.buckets.map(v => ({
        value: v.key,
        label: v.key
      })));
    } catch (e) {
      toasts.addError(e, {
        title: _i18n.i18n.translate('xpack.aiops.changePointDetection.fetchPartitionsErrorTitle', {
          defaultMessage: 'Failed to fetch partitions'
        })
      });
    }
    setIsLoading(false);
  }, [enableSearch, cancelRequest, dataView, splitField, value, runRequest, toasts]);
  (0, _react.useEffect)(function onSplitFieldChange() {
    fetchResults('');
    if (prevSplitField !== undefined && splitField !== prevSplitField) {
      onChange([]);
    }
  }, [splitField, prevSplitField, fetchResults, onChange]);
  const selectedOptions = (0, _react.useMemo)(() => {
    return value.map(v => ({
      value: v,
      label: v
    }));
  }, [value]);
  const onChangeCallback = (0, _react.useCallback)(udpate => {
    onChange(udpate.map(v => v.value));
  }, [onChange]);
  const onSearchChange = (0, _react.useMemo)(() => (0, _lodash.debounce)(fetchResults, 500), [fetchResults]);
  const onCreateOption = (0, _react.useCallback)(v => {
    onChange([...value, v]);
  }, [onChange, value]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.aiops.changePointDetection.partitionsLabel', {
      defaultMessage: 'Partitions'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.aiops.changePointDetection.partitionsDescription', {
        defaultMessage: 'If not supplied, the largest change points across all split field values will be displayed.'
      }),
      position: "right",
      type: "question",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 13
      }
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isLoading: isLoading,
    fullWidth: true,
    compressed: true,
    options: options,
    selectedOptions: selectedOptions,
    onChange: onChangeCallback,
    onSearchChange: enableSearch ? onSearchChange : undefined,
    onCreateOption: !enableSearch ? onCreateOption : undefined,
    isClearable: true,
    "data-test-subj": "aiopsChangePointPartitions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 7
    }
  }));
};
exports.PartitionsSelector = PartitionsSelector;