"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mergeSampleDocumentsWithFieldCaps = mergeSampleDocumentsWithFieldCaps;
var _lodash = require("lodash");
var _std = require("@kbn/std");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mergeSampleDocumentsWithFieldCaps({
  total,
  hits,
  fieldCaps
}) {
  const valueDocCountsByField = new Map();
  const docsWithValueByField = new Map();
  const samples = hits.map(hit => {
    var _hit$_source;
    return {
      ...hit.fields,
      ...(0, _std.getFlattenedObject)((_hit$_source = hit._source) !== null && _hit$_source !== void 0 ? _hit$_source : {})
    };
  });
  const specs = Object.entries(fieldCaps.fields).map(([name, capabilities]) => {
    return {
      name,
      esTypes: Object.keys(capabilities)
    };
  });
  const typesByFields = new Map(specs.map(({
    name,
    esTypes
  }) => {
    return [name, esTypes !== null && esTypes !== void 0 ? esTypes : []];
  }));
  for (const document of samples) {
    const fieldsWithValuesInDocument = new Set();
    Object.entries(document).forEach(([field, rawValue]) => {
      if (!typesByFields.has(field)) {
        typesByFields.set(field, []);
      }
      const values = (0, _lodash.castArray)(rawValue).filter(value => {
        return typeof value === 'string' || typeof value === 'number' || typeof value === 'boolean';
      });
      if (values.length === 0) {
        return;
      }
      const uniqueValues = new Set(values);
      fieldsWithValuesInDocument.add(field);
      let valueDocCounts = valueDocCountsByField.get(field);
      if (!valueDocCounts) {
        valueDocCounts = new Map();
        valueDocCountsByField.set(field, valueDocCounts);
      }
      uniqueValues.forEach(value => {
        var _get;
        const currentCount = (_get = valueDocCounts.get(value)) !== null && _get !== void 0 ? _get : 0;
        valueDocCounts.set(value, currentCount + 1);
      });
    });
    fieldsWithValuesInDocument.forEach(field => {
      var _docsWithValueByField;
      const currentCount = (_docsWithValueByField = docsWithValueByField.get(field)) !== null && _docsWithValueByField !== void 0 ? _docsWithValueByField : 0;
      docsWithValueByField.set(field, currentCount + 1);
    });
  }
  const allFieldNames = Array.from(new Set([...typesByFields.keys(), ...valueDocCountsByField.keys()]));
  const fields = allFieldNames.map(name => {
    var _typesByFields$get, _valueDocCountsByFiel, _docsWithValueByField2;
    const types = (_typesByFields$get = typesByFields.get(name)) !== null && _typesByFields$get !== void 0 ? _typesByFields$get : [];
    const valueDocCounts = (_valueDocCountsByFiel = valueDocCountsByField.get(name)) !== null && _valueDocCountsByFiel !== void 0 ? _valueDocCountsByFiel : new Map();
    const docsWithValue = (_docsWithValueByField2 = docsWithValueByField.get(name)) !== null && _docsWithValueByField2 !== void 0 ? _docsWithValueByField2 : 0;
    const sortedValues = (0, _lodash.sortBy)(Array.from(valueDocCounts.entries()).map(([value, count]) => {
      return {
        value,
        count
      };
    }), ({
      count
    }) => -count);
    return {
      name,
      types,
      empty: docsWithValue === 0,
      cardinality: valueDocCounts.size > 0 ? valueDocCounts.size : null,
      values: sortedValues,
      documentsWithValue: docsWithValue
    };
  });
  return {
    total,
    sampled: samples.length,
    fields
  };
}