"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AIAssistantManagementSelectionPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _aiAssistantCommon = require("@kbn/ai-assistant-common");
var _ui_setting_keys = require("../common/ui_setting_keys");
var _classic_setting = require("./src/settings/classic_setting");
var _ai_assistant_type = require("../common/ai_assistant_type");
var _chat_experience_setting = require("./src/settings/chat_experience_setting");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class AIAssistantManagementSelectionPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.config = initializerContext.config.get();
    this.logger = initializerContext.logger.get();
  }
  setup(core, plugins) {
    this.registerUiSettings(core, plugins);
    return {};
  }
  registerUiSettings(core, plugins) {
    const {
      cloud
    } = plugins;
    const serverlessProjectType = cloud === null || cloud === void 0 ? void 0 : cloud.serverless.projectType;

    // Do not register the setting in a serverless project
    if (!serverlessProjectType) {
      var _this$config$preferre;
      core.uiSettings.register({
        [_ui_setting_keys.PREFERRED_AI_ASSISTANT_TYPE_SETTING_KEY]: {
          ..._classic_setting.classicSetting,
          value: (_this$config$preferre = this.config.preferredAIAssistantType) !== null && _this$config$preferre !== void 0 ? _this$config$preferre : _ai_assistant_type.AIAssistantType.Default
        }
      });
    }

    // Register chat experience setting for both stateful and serverless (except workplaceai)
    if (serverlessProjectType !== 'workplaceai') {
      // Default Agent for Elasticsearch solution view, Classic for all other cases
      core.uiSettings.register({
        [_ui_setting_keys.PREFERRED_CHAT_EXPERIENCE_SETTING_KEY]: {
          ..._chat_experience_setting.chatExperienceSetting,
          getValue: async ({
            request
          } = {}) => {
            if (request) {
              try {
                const [, startServices] = await core.getStartServices();
                // Avoid security exceptions before login - only check space when authenticated
                if (startServices.spaces && request.auth.isAuthenticated) {
                  const activeSpace = await startServices.spaces.spacesService.getActiveSpace(request);
                  if ((activeSpace === null || activeSpace === void 0 ? void 0 : activeSpace.solution) === 'es') {
                    return _aiAssistantCommon.AIChatExperience.Agent;
                  }
                }
              } catch (e) {
                this.logger.error('Error getting active space:');
                this.logger.error(e);
              }
            }
            if (this.config.preferredChatExperience) {
              return this.config.preferredChatExperience;
            }
            return _aiAssistantCommon.AIChatExperience.Classic;
          }
        }
      });
    }
  }
  start(core) {
    return {};
  }
  stop() {}
}
exports.AIAssistantManagementSelectionPlugin = AIAssistantManagementSelectionPlugin;