"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveBindingDeactivations = resolveBindingDeactivations;
const common_1 = require("@inversifyjs/common");
const resolveBindingPreDestroy_1 = require("./resolveBindingPreDestroy");
const resolveBindingServiceDeactivations_1 = require("./resolveBindingServiceDeactivations");
const CACHE_KEY_TYPE = 'cache';
function resolveBindingDeactivations(params, binding) {
    const preDestroyResult = (0, resolveBindingPreDestroy_1.resolveBindingPreDestroy)(params, binding);
    if (preDestroyResult === undefined) {
        return resolveBindingDeactivationsAfterPreDestroy(params, binding);
    }
    return preDestroyResult.then(() => resolveBindingDeactivationsAfterPreDestroy(params, binding));
}
function resolveBindingDeactivationsAfterPreDestroy(params, binding) {
    const bindingCache = binding.cache;
    if ((0, common_1.isPromise)(bindingCache.value)) {
        return bindingCache.value.then((resolvedValue) => resolveBindingDeactivationsAfterPreDestroyFromValue(params, binding, resolvedValue));
    }
    return resolveBindingDeactivationsAfterPreDestroyFromValue(params, binding, bindingCache.value);
}
function resolveBindingDeactivationsAfterPreDestroyFromValue(params, binding, resolvedValue) {
    let deactivationResult = undefined;
    if (binding.onDeactivation !== undefined) {
        const bindingDeactivation = binding.onDeactivation;
        deactivationResult = bindingDeactivation(resolvedValue);
    }
    if (deactivationResult === undefined) {
        return (0, resolveBindingServiceDeactivations_1.resolveBindingServiceDeactivations)(params, binding.serviceIdentifier, resolvedValue);
    }
    else {
        return deactivationResult.then(() => (0, resolveBindingServiceDeactivations_1.resolveBindingServiceDeactivations)(params, binding.serviceIdentifier, resolvedValue));
    }
}
//# sourceMappingURL=resolveBindingDeactivations.js.map