"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateConstructorMetadataArray = validateConstructorMetadataArray;
const InversifyCoreError_1 = require("../../error/models/InversifyCoreError");
const InversifyCoreErrorKind_1 = require("../../error/models/InversifyCoreErrorKind");
function validateConstructorMetadataArray(type, value) {
    const undefinedIndexes = [];
    if (value.length < type.length) {
        throw new InversifyCoreError_1.InversifyCoreError(InversifyCoreErrorKind_1.InversifyCoreErrorKind.missingInjectionDecorator, `Found unexpected missing metadata on type "${type.name}". "${type.name}" constructor requires at least ${type.length.toString()} arguments, found ${value.length.toString()} instead.
Are you using @inject, @multiInject or @unmanaged decorators in every non optional constructor argument?

If you're using typescript and want to rely on auto injection, set "emitDecoratorMetadata" compiler option to true`);
    }
    // Using a for loop to ensure empty values are traversed as well
    for (let i = 0; i < value.length; ++i) {
        const element = value[i];
        if (element === undefined) {
            undefinedIndexes.push(i);
        }
    }
    if (undefinedIndexes.length > 0) {
        throw new InversifyCoreError_1.InversifyCoreError(InversifyCoreErrorKind_1.InversifyCoreErrorKind.missingInjectionDecorator, `Found unexpected missing metadata on type "${type.name}" at constructor indexes "${undefinedIndexes.join('", "')}".

Are you using @inject, @multiInject or @unmanaged decorators at those indexes?

If you're using typescript and want to rely on auto injection, set "emitDecoratorMetadata" compiler option to true`);
    }
}
//# sourceMappingURL=validateConstructorMetadataArray.js.map