"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.iconLoadingOpacity = exports.euiIconStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _templateObject;
function _taggedTemplateLiteral(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var iconLoadingOpacity = exports.iconLoadingOpacity = 0.05;
var iconLoading = (0, _react.keyframes)(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n  0% {\n    opacity: ", ";\n  }\n\n  100% {\n    opacity: 1;\n  }\n"])), iconLoadingOpacity);
var _ref = process.env.NODE_ENV === "production" ? {
  name: "p0011s-logoElasticOutline",
  styles: "*[fill]{fill:none!important;stroke:currentColor!important;};label:logoElasticOutline;"
} : {
  name: "p0011s-logoElasticOutline",
  styles: "*[fill]{fill:none!important;stroke:currentColor!important;};label:logoElasticOutline;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "uacjc5-inherit",
  styles: "color:inherit;label:inherit;"
} : {
  name: "uacjc5-inherit",
  styles: "color:inherit;label:inherit;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiIconStyles = exports.euiIconStyles = function euiIconStyles(_ref3) {
  var euiTheme = _ref3.euiTheme;
  return {
    // Base
    euiIcon: /*#__PURE__*/(0, _react.css)("flex-shrink:0;display:inline-block;vertical-align:middle;fill:currentColor;transform:translate(0, 0);.euiIcon__fillNegative{fill:", euiTheme.colors.darkestShade, ";};label:euiIcon;"),
    // Colors
    primary: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textPrimary, ";;label:primary;"),
    accent: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textAccent, ";;label:accent;"),
    accentSecondary: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textAccentSecondary, ";;label:accentSecondary;"),
    ghost: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.ghost, ";*[fill],.euiIcon__fillNegative{fill:currentColor!important;};label:ghost;"),
    subdued: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textSubdued, ";;label:subdued;"),
    text: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textHeading, ";*[fill],.euiIcon__fillNegative{fill:currentColor!important;};label:text;"),
    neutral: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textNeutral, ";;label:neutral;"),
    success: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textSuccess, ";;label:success;"),
    warning: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textWarning, ";;label:warning;"),
    risk: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textRisk, ";;label:risk;"),
    danger: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textDanger, ";;label:danger;"),
    inherit: _ref2,
    default: /*#__PURE__*/(0, _react.css)(";label:default;"),
    customColor: /*#__PURE__*/(0, _react.css)(";label:customColor;"),
    logoElasticOutline: _ref,
    // Sizes
    original: /*#__PURE__*/(0, _react.css)(";label:original;"),
    s: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)(euiTheme.size.m), ";label:s;"),
    m: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)(euiTheme.size.base), ";label:m;"),
    l: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)(euiTheme.size.l), ";label:l;"),
    xl: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)(euiTheme.size.xl), ";label:xl;"),
    xxl: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)(euiTheme.size.xxl), ";label:xxl;"),
    // Variants
    // App icons are two-toned. This provides the base color.
    app: /*#__PURE__*/(0, _react.css)("fill:", euiTheme.colors.textParagraph, ";.euiIcon__fillSecondary{fill:", euiTheme.colors.primary, ";};label:app;"),
    logo: /*#__PURE__*/(0, _react.css)(";label:logo;"),
    // Loading states
    isLoading: /*#__PURE__*/(0, _react.css)("opacity:", iconLoadingOpacity, ";background-color:currentColor;border-radius:", euiTheme.border.radius.small, ";;label:isLoading;"),
    isLoaded: /*#__PURE__*/(0, _react.css)(_global_styling.euiCanAnimate, "{animation:", iconLoading, " ", euiTheme.animation.normal, " ease-in 0s 1 forwards;};label:isLoaded;")
  };
};