"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _react = _interopRequireWildcard(require("react"));
var _radio_group = require("./radio_group");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ /// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../../cypress/support" />
var RadioGroup = function RadioGroup() {
  var radioGroupItemId__1 = 'cy-radio-id-1';
  var radioGroupItemId__2 = 'cy-radio-id-2';
  var radioGroupItemId__3 = 'cy-radio-id-3';
  var radioGroupItemId__4 = 'cy-radio-id-4';
  var radios = [{
    id: radioGroupItemId__1,
    label: 'Option one'
  }, {
    id: radioGroupItemId__2,
    label: 'Option two'
  }, {
    id: radioGroupItemId__3,
    label: 'Option three is disabled',
    disabled: true
  }, {
    id: radioGroupItemId__4,
    label: 'Option four'
  }];
  var _useState = (0, _react.useState)(radioGroupItemId__1),
    _useState2 = _slicedToArray(_useState, 2),
    radioIdSelected = _useState2[0],
    setRadioIdSelected = _useState2[1];
  return (0, _react2.jsx)(_radio_group.EuiRadioGroup, {
    options: radios,
    idSelected: radioIdSelected,
    onChange: function onChange(id) {
      return setRadioIdSelected(id);
    },
    name: "radio group",
    legend: {
      children: (0, _react2.jsx)("span", null, "This is a legend for a radio group")
    }
  });
};
describe('EuiRadioGroup', function () {
  beforeEach(function () {
    cy.realMount((0, _react2.jsx)(RadioGroup, null));
  });
  describe('Automated accessibility check', function () {
    it('has zero violations when rendered', function () {
      cy.checkAxe();
    });
  });
  describe('Keyboard accessibility', function () {
    it('has zero violations after traversing radio group', function () {
      cy.realPress('Tab');
      cy.get('#cy-radio-id-1').should('have.focus');
      cy.realPress('Space');
      cy.get('#cy-radio-id-1').should('be.checked');
      cy.realPress('ArrowDown');
      cy.get('#cy-radio-id-2').should('be.checked');
      cy.realPress('ArrowRight');
      cy.get('#cy-radio-id-3').should('not.be.checked');
      cy.get('#cy-radio-id-4').should('be.checked');
      cy.checkAxe();
    });
  });
  describe('Disabled radio button accessibility', function () {
    it('affects no change after clicking the disabled radio button', function () {
      cy.get('#cy-radio-id-3').realClick();
      cy.get('#cy-radio-id-3').should('not.be.checked');
      cy.checkAxe();
    });
  });
});