"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _react = _interopRequireWildcard(require("react"));
var _checkbox_group = require("./checkbox_group");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ /// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../../cypress/support" />
var CheckBoxGroup = function CheckBoxGroup() {
  var checkboxGroupItemId__1 = 'cy-group-id-1';
  var checkboxGroupItemId__2 = 'cy-group-id-2';
  var checkboxGroupItemId__3 = 'cy-group-id-3';
  var checkboxGroupItemId__4 = 'cy-group-id-4';
  var checkboxes = [{
    id: checkboxGroupItemId__1,
    label: 'Option one',
    'data-test-subj': 'cy-checkbox-1'
  }, {
    id: checkboxGroupItemId__2,
    label: 'Option two is checked by default',
    className: 'classNameTest',
    'data-test-subj': 'cy-checkbox-2'
  }, {
    id: checkboxGroupItemId__3,
    label: 'Option three is disabled',
    'data-test-subj': 'cy-checkbox-3',
    disabled: true
  }, {
    id: checkboxGroupItemId__4,
    label: 'Option four',
    'data-test-subj': 'cy-checkbox-4'
  }];
  var _useState = (0, _react.useState)(_defineProperty({}, checkboxGroupItemId__2, true)),
    _useState2 = _slicedToArray(_useState, 2),
    checkboxIdToSelectedMap = _useState2[0],
    setCheckboxIdToSelectedMap = _useState2[1];
  var _onChange = function onChange(optionId) {
    var newCheckboxIdToSelectedMap = _objectSpread(_objectSpread({}, checkboxIdToSelectedMap), _defineProperty({}, optionId, !checkboxIdToSelectedMap[optionId]));
    setCheckboxIdToSelectedMap(newCheckboxIdToSelectedMap);
  };
  return (0, _react2.jsx)(_checkbox_group.EuiCheckboxGroup, {
    options: checkboxes,
    idToSelectedMap: checkboxIdToSelectedMap,
    onChange: function onChange(id) {
      return _onChange(id);
    }
  });
};
describe('EuiCheckBoxGroup', function () {
  beforeEach(function () {
    cy.realMount((0, _react2.jsx)(CheckBoxGroup, null));
  });
  describe('Automated accessibility check', function () {
    it('has zero violations when rendered', function () {
      cy.checkAxe();
    });
  });
  describe('Keyboard accessibility', function () {
    it('has zero violations after traversing checkboxes', function () {
      cy.realPress('Tab');
      cy.get('[data-test-subj="cy-checkbox-1"]').should('have.focus');
      cy.realPress('Space');
      cy.get('[data-test-subj="cy-checkbox-1"]').should('be.checked');
      cy.realPress('Tab');
      cy.get('[data-test-subj="cy-checkbox-2"]').should('have.focus');
      cy.realPress('Space');
      cy.get('[data-test-subj="cy-checkbox-2"]').should('not.be.checked');
      cy.realPress('Tab');
      cy.get('[data-test-subj="cy-checkbox-4"]').should('have.focus');
      cy.checkAxe();
    });
  });
  describe('Disabled checkbox accessibility', function () {
    it('affects no change after clicking the disabled checkbox', function () {
      cy.get('[data-test-subj="cy-checkbox-3"]').realClick();
      cy.get('[data-test-subj="cy-checkbox-3"]').should('not.be.checked');
      cy.checkAxe();
    });
  });
});