"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiManagedFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../../services");
var _i18n = require("../../i18n");
var _resize_observer = require("../../observer/resize_observer");
var _flyout = require("../flyout.component");
var _flyout_menu_context = require("../flyout_menu_context");
var _activity_stage = require("./activity_stage");
var _const = require("./const");
var _context = require("./context");
var _flyout_managed = require("./flyout_managed.styles");
var _hooks = require("./hooks");
var _selectors = require("./selectors");
var _validation = require("./validation");
var _react2 = require("@emotion/react");
var _excluded = ["id", "onClose", "onActive", "level", "size", "css", "flyoutMenuProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * Props for `EuiManagedFlyout`, the internal persistent flyout used by
 * the manager. Extends base flyout props and requires a `level` to
 * distinguish `main` vs `child` behavior.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var useFlyoutManager = function useFlyoutManager() {
  var context = (0, _hooks.useFlyoutManager)();
  if (!context) {
    throw new Error('EuiManagedFlyout must be used within an EuiFlyoutManager');
  }
  return context;
};

/**
 * Persistent managed flyout rendered inside the provider. Handles:
 * - registration/unregistration with the manager
 * - size validation and parent/child size compatibility
 * - width tracking for responsive layouts
 * - lifecycle stage transitions and data attributes for styling
 */
var EuiManagedFlyout = exports.EuiManagedFlyout = function EuiManagedFlyout(_ref) {
  var id = _ref.id,
    onCloseProp = _ref.onClose,
    onActiveProp = _ref.onActive,
    level = _ref.level,
    sizeProp = _ref.size,
    customCss = _ref.css,
    _flyoutMenuProps = _ref.flyoutMenuProps,
    props = _objectWithoutProperties(_ref, _excluded);
  var flyoutId = (0, _hooks.useFlyoutId)(id);
  var flyoutRef = (0, _react.useRef)(null);
  var _useFlyoutManager2 = useFlyoutManager(),
    addFlyout = _useFlyoutManager2.addFlyout,
    closeFlyout = _useFlyoutManager2.closeFlyout,
    setFlyoutWidth = _useFlyoutManager2.setFlyoutWidth,
    goBack = _useFlyoutManager2.goBack,
    _historyItems = _useFlyoutManager2.historyItems;
  var parentSize = (0, _hooks.useParentFlyoutSize)(flyoutId);
  var parentFlyout = (0, _selectors.useCurrentMainFlyout)();
  var layoutMode = (0, _hooks.useFlyoutLayoutMode)();
  var styles = (0, _services.useEuiMemoizedStyles)(_flyout_managed.euiManagedFlyoutStyles);

  // Set default size based on level: main defaults to 'm', child defaults to 's'
  var size = sizeProp !== null && sizeProp !== void 0 ? sizeProp : level === _const.LEVEL_CHILD ? 's' : 'm';

  // Validate size
  var sizeTypeError = (0, _validation.validateManagedFlyoutSize)(size, flyoutId, level);
  if (sizeTypeError) {
    throw new Error((0, _validation.createValidationErrorMessage)(sizeTypeError));
  }

  // For child flyouts, validate parent-child combinations
  if (level === _const.LEVEL_CHILD && parentSize && (0, _validation.isNamedSize)(size) && (0, _validation.isNamedSize)(parentSize)) {
    var combinationError = (0, _validation.validateSizeCombination)(parentSize, size);
    if (combinationError) {
      combinationError.flyoutId = flyoutId;
      combinationError.parentFlyoutId = parentFlyout === null || parentFlyout === void 0 ? void 0 : parentFlyout.flyoutId;
      combinationError.level = level;
      throw new Error((0, _validation.createValidationErrorMessage)(combinationError));
    }
  }
  var defaultTitle = (0, _i18n.useEuiI18n)('euiFlyoutManaged.defaultTitle', 'Unknown Flyout');

  // Set title from flyoutMenuProps or aria-label
  // TODO: allow aria-labelledby references to be used
  var title = (_flyoutMenuProps === null || _flyoutMenuProps === void 0 ? void 0 : _flyoutMenuProps.title) || props['aria-label'];
  if (process.env.NODE_ENV === 'development' && level === _const.LEVEL_MAIN && !title) {
    console.warn("Managed flyout \"".concat(flyoutId, "\" requires a title, which can be provided through 'flyoutMenuProps.title' or 'aria-label'. Using default title: \"").concat(defaultTitle, "\""));
    title = defaultTitle;
  }
  var isActive = (0, _hooks.useIsFlyoutActive)(flyoutId);
  var currentSession = (0, _hooks.useCurrentSession)();
  var flyoutExistsInManager = (0, _selectors.useIsFlyoutRegistered)(flyoutId);

  // Stabilize the onClose callback
  var onCloseCallbackRef = (0, _react.useRef)();
  onCloseCallbackRef.current = function (e) {
    if (onCloseProp) {
      var event = e || new MouseEvent('click');
      onCloseProp(event);
    }
  };

  // Stabilize the onActive callback
  var onActiveCallbackRef = (0, _react.useRef)();
  onActiveCallbackRef.current = onActiveProp;

  // Track if flyout was ever registered to avoid false positives on initial mount
  var wasRegisteredRef = (0, _react.useRef)(false);

  // Register with flyout manager context when open, remove when closed
  (0, _react.useEffect)(function () {
    addFlyout(flyoutId, title, level, size);
    return function () {
      closeFlyout(flyoutId);

      // Reset navigation tracking when explicitly closed via isOpen=false
      wasRegisteredRef.current = false;
    };
  }, [flyoutId, title, level, size, addFlyout, closeFlyout]);

  // Detect when flyout has been removed from manager state (e.g., via Back button)
  // and trigger onClose callback to notify the parent component
  (0, _react.useEffect)(function () {
    if (flyoutExistsInManager) {
      wasRegisteredRef.current = true;
    }

    // If flyout was previously registered, is marked as open, but no longer exists in manager state,
    // it was removed via navigation (Back button) - trigger close callback
    if (wasRegisteredRef.current && !flyoutExistsInManager) {
      var _onCloseCallbackRef$c;
      (_onCloseCallbackRef$c = onCloseCallbackRef.current) === null || _onCloseCallbackRef$c === void 0 || _onCloseCallbackRef$c.call(onCloseCallbackRef, new MouseEvent('navigation'));
      wasRegisteredRef.current = false; // Reset to avoid repeated calls
    }
  }, [flyoutExistsInManager, flyoutId]);

  // Monitor current session changes and fire onActive callback when this flyout becomes active
  (0, _react.useEffect)(function () {
    if (!onActiveCallbackRef.current || !currentSession) {
      return;
    }

    // Make sure callback is only fired for the flyout that changed
    var mainChanged = level === _const.LEVEL_MAIN && currentSession.mainFlyoutId === flyoutId;
    var childChanged = level === _const.LEVEL_CHILD && currentSession.childFlyoutId === flyoutId;
    if (mainChanged || childChanged) {
      onActiveCallbackRef.current();
    }
  }, [currentSession, flyoutId, level]);
  (0, _react.useEffect)(function () {
    return function () {
      // Only remove from manager on component unmount, don't trigger close callback
      closeFlyout(flyoutId);
    };
  }, [closeFlyout, flyoutId]);

  // Track width changes for flyouts
  var _useResizeObserver = (0, _resize_observer.useResizeObserver)(isActive ? flyoutRef.current : null, 'width'),
    width = _useResizeObserver.width;

  // Pass the stabilized onClose callback to the flyout menu context
  var onClose = function onClose(e) {
    var _onCloseCallbackRef$c2;
    (_onCloseCallbackRef$c2 = onCloseCallbackRef.current) === null || _onCloseCallbackRef$c2 === void 0 || _onCloseCallbackRef$c2.call(onCloseCallbackRef, e);
  };

  // Update width in manager state when it changes
  (0, _react.useEffect)(function () {
    if (isActive && width) {
      setFlyoutWidth(flyoutId, width);
    }
  }, [flyoutId, level, isActive, width, setFlyoutWidth]);
  var _useFlyoutActivitySta = (0, _activity_stage.useFlyoutActivityStage)({
      flyoutId: flyoutId,
      level: level
    }),
    activityStage = _useFlyoutActivitySta.activityStage,
    onAnimationEnd = _useFlyoutActivitySta.onAnimationEnd;

  // Note: history controls are only relevant for main flyouts
  var historyItems = (0, _react.useMemo)(function () {
    var result = level === _const.LEVEL_MAIN ? _historyItems : undefined;
    return result;
  }, [level, _historyItems]);
  var backButtonProps = (0, _react.useMemo)(function () {
    return level === _const.LEVEL_MAIN ? {
      onClick: goBack
    } : undefined;
  }, [level, goBack]);
  var showBackButton = historyItems ? historyItems.length > 0 : false;
  var flyoutMenuProps = _objectSpread(_objectSpread({}, _flyoutMenuProps), {}, {
    historyItems: historyItems,
    showBackButton: showBackButton,
    backButtonProps: backButtonProps,
    title: title
  });
  return (0, _react2.jsx)(_context.EuiFlyoutIsManagedProvider, {
    isManaged: true
  }, (0, _react2.jsx)(_flyout_menu_context.EuiFlyoutMenuContext.Provider, {
    value: {
      onClose: onClose
    }
  }, (0, _react2.jsx)(_flyout.EuiFlyoutComponent, _extends({
    id: flyoutId,
    ref: flyoutRef,
    css: [styles.managedFlyout, customCss, styles.stage(activityStage, props.side, level), ";label:EuiManagedFlyout;"]
  }, _objectSpread(_objectSpread({}, props), {}, _defineProperty(_defineProperty(_defineProperty({
    onClose: onClose,
    size: size,
    flyoutMenuProps: flyoutMenuProps,
    onAnimationEnd: onAnimationEnd
  }, _const.PROPERTY_FLYOUT, true), _const.PROPERTY_LAYOUT_MODE, layoutMode), _const.PROPERTY_LEVEL, level))))));
};