"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiMainFlyoutStyles = void 0;
var _react = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Emotion styles for the main (parent) managed flyout.
 * Adds subtle borders when a child flyout is present, depending on side.
 *
 * Returns an object with:
 * - `hasChildFlyout.left` and `.right`: border styles to separate from child.
 */
var euiMainFlyoutStyles = exports.euiMainFlyoutStyles = function euiMainFlyoutStyles(euiThemeContext) {
  var thin = euiThemeContext.euiTheme.border.thin;
  return {
    hasChildFlyout: {
      left: /*#__PURE__*/(0, _react.css)("box-shadow:none;border-inline-end:", thin, ";;label:left;"),
      right: /*#__PURE__*/(0, _react.css)("box-shadow:none;border-inline-start:", thin, ";;label:right;")
    }
  };
};