"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFacetButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _badge = require("../badge");
var _loading = require("../loading");
var _inner_text = require("../inner_text");
var _services = require("../../services");
var _facet_button = require("./facet_button.styles");
var _button_display = require("../button/button_display/_button_display");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "icon", "isDisabled", "isLoading", "isSelected", "quantity", "buttonRef"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiFacetButton = exports.EuiFacetButton = function EuiFacetButton(_ref) {
  var children = _ref.children,
    className = _ref.className,
    icon = _ref.icon,
    _ref$isDisabled = _ref.isDisabled,
    isDisabled = _ref$isDisabled === void 0 ? false : _ref$isDisabled,
    _ref$isLoading = _ref.isLoading,
    isLoading = _ref$isLoading === void 0 ? false : _ref$isLoading,
    _ref$isSelected = _ref.isSelected,
    isSelected = _ref$isSelected === void 0 ? false : _ref$isSelected,
    quantity = _ref.quantity,
    buttonRef = _ref.buttonRef,
    rest = _objectWithoutProperties(_ref, _excluded);
  // If in the loading state, force disabled to true
  isDisabled = (0, _button_display.isButtonDisabled)({
    isDisabled: isDisabled,
    isLoading: isLoading
  });
  var selection = isSelected ? 'isSelected' : 'unSelected';
  var classes = (0, _classnames.default)('euiFacetButton', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_facet_button.euiFacetButtonStyles);
  var cssStyles = [styles.euiFacetButton];
  var textStyles = (0, _services.useEuiMemoizedStyles)(_facet_button.euiFacetButtonTextStyles);
  var cssTextStyles = [textStyles.euiFacetButton__text, textStyles[selection]];

  // Spreading an obj/conditionally passing the `css` prop makes it so
  // an empty `css-0` className isn't rendered in the DOM
  var disabledStyles = (0, _react.useMemo)(function () {
    return isDisabled ? {
      css: _facet_button.euiFacetButton__disabled
    } : undefined;
  }, [isDisabled]);

  // Add quantity number if provided or loading indicator
  var buttonQuantity = (0, _react.useMemo)(function () {
    if (isLoading) {
      return (0, _react2.jsx)(_loading.EuiLoadingSpinner, {
        size: "m"
      });
    } else if (typeof quantity === 'number') {
      return (0, _react2.jsx)(_badge.EuiNotificationBadge, _extends({}, disabledStyles, {
        className: "euiFacetButton__quantity",
        size: "m",
        color: !isSelected || isDisabled ? 'subdued' : 'accent'
      }), quantity);
    }
  }, [quantity, isLoading, isDisabled, disabledStyles, isSelected]);

  // Add an icon to the button if one exists.
  var buttonIcon = (0, _react.useMemo)(function () {
    if ( /*#__PURE__*/_react.default.isValidElement(icon)) {
      return (0, _services.cloneElementWithCss)(icon, _objectSpread({
        className: 'euiFacetButton__icon'
      }, disabledStyles));
    }
  }, [icon, disabledStyles]);
  return (0, _react2.jsx)(_inner_text.EuiInnerText, null, function (ref, innerText) {
    return (0, _react2.jsx)(_button_display.EuiButtonDisplay, _extends({
      className: classes,
      css: cssStyles,
      isDisabled: isDisabled,
      ref: buttonRef,
      title: rest['aria-label'] || innerText,
      size: "s"
    }, rest), buttonIcon, (0, _react2.jsx)("span", {
      css: cssTextStyles,
      className: "euiFacetButton__text",
      "data-text": innerText,
      ref: ref
    }, children), buttonQuantity);
  });
};
EuiFacetButton.propTypes = {
  buttonRef: _propTypes.default.any,
  /**
     * ReactNode to render as this component's content
     */
  children: _propTypes.default.oneOfType([_propTypes.default.node.isRequired, _propTypes.default.node]),
  /**
     * Any node, but preferably a `EuiIcon` or `EuiAvatar`
     */
  icon: _propTypes.default.node,
  /**
     * Controls the disabled behavior via the native `disabled` attribute.
     */
  isDisabled: _propTypes.default.oneOfType([_propTypes.default.bool, _propTypes.default.bool]),
  /**
     * Force disables the button and changes the icon to a loading spinner
     */
  /**
     * Adds/swaps for loading spinner & disables
     */
  isLoading: _propTypes.default.bool,
  /**
     * Applies the boolean state as the `aria-pressed` property to create a toggle button.
     * *Only use when the readable text does not change between states.*
     */
  /**
     * Changes visual of button to indicate it's currently selected
     */
  isSelected: _propTypes.default.bool,
  /**
     * Adds a notification indicator for displaying the quantity provided
     */
  quantity: _propTypes.default.number,
  element: _propTypes.default.oneOf(["a", "button", "span"]),
  size: _propTypes.default.any,
  /**
     * Extends the button to 100% width
     */
  fullWidth: _propTypes.default.bool,
  /**
     * Override the default minimum width
     */
  minWidth: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.oneOf([false])]),
  /**
     * Object of props passed to the <span/> wrapping the button's content
     */
  contentProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }),
  style: _propTypes.default.any,
  type: _propTypes.default.any,
  /**
     * NOTE: Beta feature, may be changed or removed in the future
     *
     * Changes the native `disabled` attribute to `aria-disabled` to preserve focusability.
     * This results in a semantically disabled button without the default browser handling of the disabled state.
     *
     * Use e.g. when a disabled button should have a tooltip.
     */
  hasAriaDisabled: _propTypes.default.bool,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};