"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.safariLoadingWorkaround = exports.euiBasicTableBodyLoading = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _templateObject;
function _taggedTemplateLiteral(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var tableLoadingLine = (0, _react.keyframes)(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n  from {\n    ", "\n    ", "\n  }\n\n  20% {\n    ", "\n    ", "\n  }\n\n  80% {\n    ", "\n    ", "\n  }\n\n  100% {\n    ", "\n    ", "\n  }\n"])), (0, _global_styling.logicalCSS)('left', 0), (0, _global_styling.logicalCSS)('width', 0), (0, _global_styling.logicalCSS)('left', 0), (0, _global_styling.logicalCSS)('width', '40%'), (0, _global_styling.logicalCSS)('left', '60%'), (0, _global_styling.logicalCSS)('width', '40%'), (0, _global_styling.logicalCSS)('left', '100%'), (0, _global_styling.logicalCSS)('width', 0));
var euiBasicTableBodyLoading = exports.euiBasicTableBodyLoading = function euiBasicTableBodyLoading(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return /*#__PURE__*/(0, _react.css)("position:relative;overflow:hidden;&::before{position:absolute;content:'';", (0, _global_styling.logicalCSS)('width', '100%'), " ", (0, _global_styling.logicalCSS)('height', euiTheme.border.width.thick), " background-color:", euiTheme.colors.primary, ";animation:", tableLoadingLine, " 1s linear infinite;", _global_styling.euiCantAnimate, "{animation:none;background:repeating-linear-gradient(\n          -45deg,\n          ", euiTheme.colors.backgroundBasePlain, ",\n          ", euiTheme.colors.backgroundBasePlain, " ", euiTheme.size.xs, ",\n          ", euiTheme.colors.primary, " ", euiTheme.size.xs, ",\n          ", euiTheme.colors.primary, " ", euiTheme.size.s, "\n        );", (0, _global_styling.highContrastModeStyles)(euiThemeContext, {
    forced: "\n              ".concat((0, _global_styling.preventForcedColors)(euiThemeContext), "\n            ")
  }), ";}};label:euiBasicTableBodyLoading;");
};

// Fix to make the loading indicator position correctly in Safari
// For whatever annoying reason, Safari doesn't respect `position: relative;`
// on `tbody` without `position: relative` on the parent `table`
var safariLoadingWorkaround = exports.safariLoadingWorkaround = process.env.NODE_ENV === "production" ? {
  name: "6xbnw4-safariLoadingWorkaround",
  styles: "position:relative;label:safariLoadingWorkaround;"
} : {
  name: "6xbnw4-safariLoadingWorkaround",
  styles: "position:relative;label:safariLoadingWorkaround;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};