"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.registerGlobalSessionContextProvider = registerGlobalSessionContextProvider;
var tslib_1 = require("tslib");
var rxjs_1 = require("rxjs");
var js_sha256_1 = require("js-sha256");
var moment_1 = tslib_1.__importDefault(require("moment"));
var SESSION_STORAGE_KEY = 'ebt_global_session';
function registerGlobalSessionContextProvider(_a) {
    var analyticsClient = _a.analyticsClient, userId$ = _a.userId$, organizationId = _a.organizationId;
    var sessionId$ = userId$.pipe((0, rxjs_1.filter)(function (userId) { return !!userId; }), (0, rxjs_1.map)(function (userId) {
        var startOfTheDay = (0, moment_1.default)().utc().startOf('day').format('YYYY-MM-DD');
        return (0, js_sha256_1.sha256)("".concat(organizationId, ":").concat(userId, ":").concat(startOfTheDay));
    }));
    analyticsClient.registerContextProvider({
        name: 'global_session',
        schema: {
            global_session: {
                type: 'keyword',
                _meta: {
                    description: 'Global session ID',
                },
            },
        },
        context$: (0, rxjs_1.merge)(sessionId$, (0, rxjs_1.of)(sessionStorage.getItem(SESSION_STORAGE_KEY))).pipe((0, rxjs_1.filter)(function (sessionId) { return !!sessionId; }), (0, rxjs_1.tap)(function (sessionId) {
            sessionStorage.setItem(SESSION_STORAGE_KEY, sessionId);
        }), (0, rxjs_1.distinctUntilChanged)(), (0, rxjs_1.map)(function (sessionId) { return ({ global_session: sessionId }); })),
    });
}
