"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSmallMultiplesIndexOrderSelector = void 0;
const get_specs_1 = require("./get_specs");
const chart_types_1 = require("../../chart_types");
const spec_type_1 = require("../../specs/spec_type");
const create_selector_1 = require("../create_selector");
const get_specs_from_store_1 = require("../utils/get_specs_from_store");
exports.getSmallMultiplesIndexOrderSelector = (0, create_selector_1.createCustomCachedSelector)([get_specs_1.getSpecs], (specs) => {
    const [smallMultiples] = (0, get_specs_from_store_1.getSpecsFromStore)(specs, chart_types_1.ChartType.Global, spec_type_1.SpecType.SmallMultiples);
    const groupBySpecs = (0, get_specs_from_store_1.getSpecsFromStore)(specs, chart_types_1.ChartType.Global, spec_type_1.SpecType.IndexOrder);
    return {
        horizontal: groupBySpecs.find((s) => s.id === smallMultiples?.splitHorizontally),
        vertical: groupBySpecs.find((s) => s.id === smallMultiples?.splitVertically),
    };
});
//# sourceMappingURL=get_small_multiples_index_order.js.map