"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderRect = renderRect;
exports.renderRectStroke = renderRectStroke;
const line_1 = require("./line");
const color_library_wrappers_1 = require("../../../common/color_library_wrappers");
function renderRect(ctx, { x, y, width, height }, { color, texture }, stroke, disableBorderOffset = false) {
    const borderOffset = !disableBorderOffset && stroke.width >= line_1.MIN_STROKE_WIDTH ? stroke.width : 0;
    if (stroke.width >= line_1.MIN_STROKE_WIDTH && height >= borderOffset && width >= borderOffset) {
        ctx.strokeStyle = (0, color_library_wrappers_1.RGBATupleToString)(stroke.color);
        ctx.lineWidth = stroke.width;
        ctx.beginPath();
        ctx.rect(x + borderOffset / 2, y + borderOffset / 2, width - borderOffset, height - borderOffset);
        ctx.setLineDash(stroke.dash ?? []);
        ctx.lineCap = stroke.dash?.length ? 'butt' : 'square';
        ctx.stroke();
    }
    ctx.beginPath();
    ctx.rect(x + borderOffset, y + borderOffset, width - borderOffset * 2, height - borderOffset * 2);
    ctx.fillStyle = (0, color_library_wrappers_1.RGBATupleToString)(color);
    ctx.fill();
    if (texture) {
        ctx.fillStyle = texture.pattern;
        ctx.fill();
    }
}
function renderRectStroke(ctx, rect, stroke, strokedSides) {
    if (stroke.width < line_1.MIN_STROKE_WIDTH ||
        (!strokedSides.left && !strokedSides.right && !strokedSides.top && !strokedSides.bottom)) {
        return;
    }
    const { x, y, width, height } = normalizeRect(rect);
    const borderOffsetLeft = strokedSides.left ? stroke.width : 0;
    const borderOffsetRight = strokedSides.right ? stroke.width : 0;
    const borderOffsetTop = strokedSides.top ? stroke.width : 0;
    const borderOffsetBottom = strokedSides.bottom ? stroke.width : 0;
    ctx.strokeStyle = (0, color_library_wrappers_1.RGBATupleToString)(stroke.color);
    ctx.lineWidth = stroke.width;
    ctx.setLineDash(stroke.dash ?? []);
    ctx.lineCap = stroke.dash?.length ? 'butt' : 'square';
    const x0 = x + borderOffsetLeft / 2;
    const x1 = x + width - borderOffsetRight / 2;
    const y0 = y + borderOffsetTop / 2;
    const y1 = y + height - borderOffsetBottom / 2;
    ctx.beginPath();
    if (strokedSides.top) {
        ctx.moveTo(x0, y0);
        ctx.lineTo(x1, y0);
    }
    if (strokedSides.right) {
        ctx.moveTo(x1, y0);
        ctx.lineTo(x1, y1);
    }
    if (strokedSides.bottom) {
        ctx.moveTo(x1, y1);
        ctx.lineTo(x0, y1);
    }
    if (strokedSides.left) {
        ctx.moveTo(x0, y1);
        ctx.lineTo(x0, y0);
    }
    ctx.stroke();
}
function normalizeRect(rect) {
    let { x, y, width, height } = rect;
    if (width < 0) {
        x += width;
        width = -width;
    }
    if (height < 0) {
        y += height;
        height = -height;
    }
    return { x, y, width, height };
}
//# sourceMappingURL=rect.js.map