"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.chartTypeSelectors = void 0;
const _1 = require(".");
const chart_selectors_1 = require("./bullet_graph/chart_selectors");
const chart_selectors_2 = require("./flame_chart/chart_selectors");
const chart_selectors_3 = require("./goal_chart/state/chart_selectors");
const chart_selectors_4 = require("./heatmap/state/chart_selectors");
const chart_selectors_5 = require("./metric/state/chart_selectors");
const chart_selectors_6 = require("./partition_chart/state/chart_selectors");
const chart_selectors_7 = require("./timeslip/chart_selectors");
const chart_selectors_8 = require("./wordcloud/state/chart_selectors");
const chart_selectors_9 = require("./xy_chart/state/chart_selectors");
exports.chartTypeSelectors = {
    [_1.ChartType.Goal]: chart_selectors_3.chartSelectorsFactory,
    [_1.ChartType.Partition]: chart_selectors_6.chartSelectorsFactory,
    [_1.ChartType.Flame]: chart_selectors_2.chartSelectorsFactory,
    [_1.ChartType.Timeslip]: chart_selectors_7.chartSelectorsFactory,
    [_1.ChartType.XYAxis]: chart_selectors_9.chartSelectorsFactory,
    [_1.ChartType.Heatmap]: chart_selectors_4.chartSelectorsFactory,
    [_1.ChartType.Wordcloud]: chart_selectors_8.chartSelectorsFactory,
    [_1.ChartType.Metric]: chart_selectors_5.chartSelectorsFactory,
    [_1.ChartType.Bullet]: chart_selectors_1.chartSelectorsFactory,
    [_1.ChartType.Global]: () => null,
};
//# sourceMappingURL=chart_type_selectors.js.map