/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

package org.elasticsearch.xpack.core.inference.chunking;

import org.elasticsearch.inference.ChunkingSettings;

import java.util.List;

public interface Chunker {
    record ChunkOffset(int start, int end) {};

    List<ChunkOffset> chunk(String input, ChunkingSettings chunkingSettings);
}
