/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.testclusters;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.elasticsearch.gradle.testclusters.ElasticsearchCluster;
import org.elasticsearch.gradle.testclusters.TestClusterInfo;
import org.elasticsearch.gradle.testclusters.TestClusterValueSource;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;

public abstract class TestClustersRegistry
implements BuildService<BuildServiceParameters.None> {
    private static final Logger logger = Logging.getLogger(TestClustersRegistry.class);
    private static final String TESTCLUSTERS_INSPECT_FAILURE = "testclusters.inspect.failure";
    private final Boolean allowClusterToSurvive = Boolean.valueOf(System.getProperty("testclusters.inspect.failure", "false"));
    private final Set<ElasticsearchCluster> runningClusters = new HashSet<ElasticsearchCluster>();
    private final Map<String, Process> nodeProcesses = new HashMap<String, Process>();

    @Inject
    public abstract ProviderFactory getProviderFactory();

    public void claimCluster(ElasticsearchCluster cluster) {
        int claims = cluster.addClaim();
        if (claims > 1) {
            cluster.setShared(true);
        }
    }

    public void maybeStartCluster(ElasticsearchCluster cluster) {
        if (this.runningClusters.contains(cluster)) {
            return;
        }
        this.runningClusters.add(cluster);
        cluster.start();
    }

    public Provider<TestClusterInfo> getClusterInfo(String clusterName) {
        return this.getProviderFactory().of(TestClusterValueSource.class, spec -> {
            ((TestClusterValueSource.Parameters)spec.getParameters()).getService().set((Object)this);
            ((TestClusterValueSource.Parameters)spec.getParameters()).getClusterName().set((Object)clusterName);
        });
    }

    public void stopCluster(ElasticsearchCluster cluster, boolean taskFailed) {
        if (taskFailed) {
            if (this.allowClusterToSurvive.booleanValue()) {
                logger.info("Not stopping clusters, disabled by property");
                int i = 1;
                while (true) {
                    logger.lifecycle("No more test clusters left to run, going to sleep because {} was set, interrupt (^C) to stop clusters.", new Object[]{TESTCLUSTERS_INSPECT_FAILURE});
                    try {
                        Thread.sleep(1000 * i);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    i += i;
                }
            }
            cluster.stop(true);
            this.runningClusters.remove(cluster);
        } else {
            int currentClaims = cluster.removeClaim();
            if (currentClaims <= 0 && this.runningClusters.contains(cluster)) {
                cluster.stop(false);
                this.runningClusters.remove(cluster);
            }
        }
    }

    public TestClusterInfo getClusterDetails(String path, String clusterName) {
        ElasticsearchCluster cluster = this.runningClusters.stream().filter(c -> c.getPath().equals(path)).filter(c -> c.getName().equals(clusterName)).findFirst().orElseThrow();
        return new TestClusterInfo(cluster.getAllHttpSocketURI(), cluster.getAllTransportPortURI(), cluster.getNodes().stream().map(n -> n.getAuditLog()).collect(Collectors.toList()));
    }

    public void restart(String path, String clusterName) {
        ElasticsearchCluster cluster = this.runningClusters.stream().filter(c -> c.getPath().equals(path)).filter(c -> c.getName().equals(clusterName)).findFirst().orElseThrow();
        cluster.restart();
    }

    public void nextNodeToNextVersion(Provider<ElasticsearchCluster> cluster) {
        this.nextNodeToNextVersion((ElasticsearchCluster)cluster.get());
    }

    public void nextNodeToNextVersion(ElasticsearchCluster cluster) {
        this.nextNodeToNextVersion(cluster.getPath(), cluster.getName());
    }

    public void nextNodeToNextVersion(String path, String clusterName) {
        ElasticsearchCluster cluster = this.runningClusters.stream().filter(c -> c.getPath().equals(path)).filter(c -> c.getName().equals(clusterName)).findFirst().orElseThrow();
        cluster.nextNodeToNextVersion();
    }

    public void storeProcess(String id, Process esProcess) {
        this.nodeProcesses.put(id, esProcess);
    }

    public Process getProcess(String id) {
        return this.nodeProcesses.get(id);
    }
}

