/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.jarhell;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import javax.inject.Inject;
import org.elasticsearch.gradle.LoggedExec;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;
import org.gradle.process.JavaExecSpec;

@CacheableTask
public class JarHellTask
extends DefaultTask {
    private FileCollection jarHellRuntimeClasspath;
    private FileCollection classpath;
    private ExecOperations execOperations;
    private ProjectLayout projectLayout;

    @Inject
    public JarHellTask(ExecOperations execOperations, ProjectLayout projectLayout) {
        this.execOperations = execOperations;
        this.projectLayout = projectLayout;
        this.setDescription("Runs CheckJarHell on the configured classpath");
    }

    @OutputFile
    public File getSuccessMarker() {
        return new File((File)this.projectLayout.getBuildDirectory().getAsFile().get(), "markers/" + this.getName());
    }

    @TaskAction
    public void runJarHellCheck() throws IOException {
        LoggedExec.javaexec(this.execOperations, (Action<JavaExecSpec>)((Action)spec -> {
            spec.environment("CLASSPATH", (Object)this.getJarHellRuntimeClasspath().plus(this.getClasspath()).getAsPath());
            spec.getMainClass().set((Object)"org.elasticsearch.jdk.JarHell");
        }));
        this.writeMarker();
    }

    private void writeMarker() throws IOException {
        Files.write(this.getSuccessMarker().toPath(), new byte[0], StandardOpenOption.CREATE);
    }

    @CompileClasspath
    @SkipWhenEmpty
    public FileCollection getClasspath() {
        return this.classpath == null ? null : this.classpath.filter(File::exists);
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    @Classpath
    public FileCollection getJarHellRuntimeClasspath() {
        return this.jarHellRuntimeClasspath;
    }

    public void setJarHellRuntimeClasspath(FileCollection jarHellRuntimeClasspath) {
        this.jarHellRuntimeClasspath = jarHellRuntimeClasspath;
    }
}

