/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.RemoteClusterActionType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.TaskId;

public class GetCheckpointAction
extends ActionType<Response> {
    public static final GetCheckpointAction INSTANCE = new GetCheckpointAction();
    public static final String NAME = "indices:monitor/transform/checkpoint";
    public static final RemoteClusterActionType<Response> REMOTE_TYPE = new RemoteClusterActionType("indices:monitor/transform/checkpoint", Response::new);

    private GetCheckpointAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse {
        private final Map<String, long[]> checkpoints;

        public Response(Map<String, long[]> checkpoints) {
            this.checkpoints = checkpoints;
        }

        public Response(StreamInput in) throws IOException {
            this.checkpoints = in.readOrderedMap(StreamInput::readString, StreamInput::readLongArray);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.getCheckpoints(), StreamOutput::writeLongArray);
        }

        public Map<String, long[]> getCheckpoints() {
            return Collections.unmodifiableMap(this.checkpoints);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Response that = (Response)((Object)obj);
            return this.checkpoints.size() == that.checkpoints.size() && this.checkpoints.entrySet().stream().allMatch(e -> Arrays.equals((long[])e.getValue(), that.checkpoints.get(e.getKey())));
        }

        public int hashCode() {
            int hash = 1;
            for (Map.Entry<String, long[]> e : this.checkpoints.entrySet()) {
                hash = 31 * hash + Objects.hash(e.getKey(), Arrays.hashCode(e.getValue()));
            }
            return hash;
        }
    }

    public static class Request
    extends LegacyActionRequest
    implements IndicesRequest.Replaceable {
        private String[] indices;
        private final IndicesOptions indicesOptions;
        private final QueryBuilder query;
        private final String cluster;
        private final TimeValue timeout;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.indices = in.readStringArray();
            this.indicesOptions = IndicesOptions.readIndicesOptions((StreamInput)in);
            this.query = (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class);
            this.cluster = in.readOptionalString();
            this.timeout = in.readOptionalTimeValue();
        }

        public Request(String[] indices, IndicesOptions indicesOptions, QueryBuilder query, String cluster, TimeValue timeout) {
            this.indices = indices != null ? indices : org.elasticsearch.common.Strings.EMPTY_ARRAY;
            this.indicesOptions = indicesOptions;
            this.query = query;
            this.cluster = cluster;
            this.timeout = timeout;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public String[] indices() {
            return this.indices;
        }

        public IndicesOptions indicesOptions() {
            return this.indicesOptions;
        }

        public QueryBuilder getQuery() {
            return this.query;
        }

        public String getCluster() {
            return this.cluster;
        }

        public TimeValue getTimeout() {
            return this.timeout;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Request that = (Request)((Object)obj);
            return Arrays.equals(this.indices, that.indices) && Objects.equals(this.indicesOptions, that.indicesOptions) && Objects.equals(this.query, that.query) && Objects.equals(this.cluster, that.cluster) && Objects.equals(this.timeout, that.timeout);
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.indices), this.indicesOptions, this.query, this.cluster, this.timeout);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.indices);
            this.indicesOptions.writeIndicesOptions(out);
            out.writeOptionalNamedWriteable((NamedWriteable)this.query);
            out.writeOptionalString(this.cluster);
            out.writeOptionalTimeValue(this.timeout);
        }

        public IndicesRequest indices(String ... indices) {
            this.indices = indices;
            return this;
        }

        public boolean allowsRemoteIndices() {
            return false;
        }

        public CancellableTask createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, Strings.format((String)"get_checkpoint[%d]", (Object[])new Object[]{this.indices.length}), parentTaskId, headers);
        }
    }
}

