/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.SecureString;

public final class KeyAndTimestamp
implements Writeable {
    private final SecureString key;
    private final long timestamp;

    public KeyAndTimestamp(SecureString key, long timestamp) {
        this.key = key;
        this.timestamp = timestamp;
    }

    KeyAndTimestamp(StreamInput input) throws IOException {
        this.timestamp = input.readVLong();
        byte[] keyBytes = input.readByteArray();
        char[] ref = new char[keyBytes.length];
        int len = UnicodeUtil.UTF8toUTF16((byte[])keyBytes, (int)0, (int)keyBytes.length, (char[])ref);
        this.key = new SecureString(Arrays.copyOfRange(ref, 0, len));
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public SecureString getKey() {
        return this.key;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.timestamp);
        BytesRef bytesRef = new BytesRef((CharSequence)this.key);
        out.writeVInt(bytesRef.length);
        out.writeBytes(bytesRef.bytes, bytesRef.offset, bytesRef.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyAndTimestamp that = (KeyAndTimestamp)o;
        if (this.timestamp != that.timestamp) {
            return false;
        }
        return this.key.equals((CharSequence)that.key);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }
}

