/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.settings;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.routing.allocation.DataTier;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public class UpdateSecuritySettingsAction {
    public static final ActionType<AcknowledgedResponse> INSTANCE = new ActionType("cluster:admin/xpack/security/settings/update");
    public static final String MAIN_INDEX_NAME = "security";
    public static final String TOKENS_INDEX_NAME = "security-tokens";
    public static final String PROFILES_INDEX_NAME = "security-profile";
    public static final Map<String, BiFunction<Object, ActionRequestValidationException, ActionRequestValidationException>> ALLOWED_SETTING_VALIDATORS = Map.of("index.number_of_replicas", (it, ex) -> ex, "index.auto_expand_replicas", (it, ex) -> ex, "index.routing.allocation.include._tier_preference", (it, ex) -> {
        String preference;
        String disallowedTiers;
        Set<String> allowedTiers = Set.of("data_content", "data_hot", "data_warm", "data_cold");
        if (it instanceof String && !(disallowedTiers = DataTier.parseTierList((String)(preference = (String)it)).stream().filter(tier -> !allowedTiers.contains(tier)).collect(Collectors.joining(","))).isEmpty()) {
            return ValidateActions.addValidationError((String)("disallowed data tiers [" + disallowedTiers + "] found, allowed tiers are [" + String.join((CharSequence)",", allowedTiers)), (ActionRequestValidationException)ex);
        }
        return ex;
    });

    private UpdateSecuritySettingsAction() {
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final Map<String, Object> mainIndexSettings;
        private final Map<String, Object> tokensIndexSettings;
        private final Map<String, Object> profilesIndexSettings;
        private static final ConstructingObjectParser<Request, Factory> PARSER = new ConstructingObjectParser("update_security_settings_request", false, (a, factory) -> factory.create((Map)a[0], (Map)a[1], (Map)a[2]));

        public Request(TimeValue masterNodeTimeout, TimeValue ackTimeout, Map<String, Object> mainIndexSettings, Map<String, Object> tokensIndexSettings, Map<String, Object> profilesIndexSettings) {
            super(masterNodeTimeout, ackTimeout);
            this.mainIndexSettings = Objects.requireNonNullElse(mainIndexSettings, Collections.emptyMap());
            this.tokensIndexSettings = Objects.requireNonNullElse(tokensIndexSettings, Collections.emptyMap());
            this.profilesIndexSettings = Objects.requireNonNullElse(profilesIndexSettings, Collections.emptyMap());
        }

        public static Request readFrom(StreamInput in) throws IOException {
            return new Request(in);
        }

        private Request(StreamInput in) throws IOException {
            super(in);
            this.mainIndexSettings = in.readGenericMap();
            this.tokensIndexSettings = in.readGenericMap();
            this.profilesIndexSettings = in.readGenericMap();
        }

        private Request(TimeValue masterNodeTimeout, TimeValue ackTimeout, StreamInput in) throws IOException {
            super(masterNodeTimeout, ackTimeout);
            this.mainIndexSettings = in.readGenericMap();
            this.tokensIndexSettings = in.readGenericMap();
            this.profilesIndexSettings = in.readGenericMap();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeGenericMap(this.mainIndexSettings);
            out.writeGenericMap(this.tokensIndexSettings);
            out.writeGenericMap(this.profilesIndexSettings);
        }

        public static Request parse(XContentParser parser, Factory factory) {
            return (Request)((Object)PARSER.apply(parser, (Object)factory));
        }

        public Map<String, Object> mainIndexSettings() {
            return this.mainIndexSettings;
        }

        public Map<String, Object> tokensIndexSettings() {
            return this.tokensIndexSettings;
        }

        public Map<String, Object> profilesIndexSettings() {
            return this.profilesIndexSettings;
        }

        public ActionRequestValidationException validate() {
            if (this.mainIndexSettings.isEmpty() && this.tokensIndexSettings.isEmpty() && this.profilesIndexSettings.isEmpty()) {
                return ValidateActions.addValidationError((String)"No settings given to update", null);
            }
            ActionRequestValidationException validationException = Request.validateIndexSettings(this.mainIndexSettings, UpdateSecuritySettingsAction.MAIN_INDEX_NAME, null);
            validationException = Request.validateIndexSettings(this.tokensIndexSettings, UpdateSecuritySettingsAction.TOKENS_INDEX_NAME, validationException);
            validationException = Request.validateIndexSettings(this.profilesIndexSettings, UpdateSecuritySettingsAction.PROFILES_INDEX_NAME, validationException);
            return validationException;
        }

        private static ActionRequestValidationException validateIndexSettings(Map<String, Object> indexSettings, String indexName, ActionRequestValidationException existingExceptions) {
            ActionRequestValidationException errors = existingExceptions;
            for (Map.Entry<String, Object> entry : indexSettings.entrySet()) {
                String setting = entry.getKey();
                if (ALLOWED_SETTING_VALIDATORS.containsKey(setting)) {
                    errors = ALLOWED_SETTING_VALIDATORS.get(setting).apply(entry.getValue(), errors);
                    continue;
                }
                errors = ValidateActions.addValidationError((String)("illegal setting for index [" + indexName + "]: [" + setting + "], this setting may not be configured. Only the following settings may be configured for that index: " + String.valueOf(ALLOWED_SETTING_VALIDATORS.keySet())), (ActionRequestValidationException)existingExceptions);
            }
            return errors;
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), new ParseField(UpdateSecuritySettingsAction.MAIN_INDEX_NAME, new String[0]));
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), new ParseField(UpdateSecuritySettingsAction.TOKENS_INDEX_NAME, new String[0]));
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), new ParseField(UpdateSecuritySettingsAction.PROFILES_INDEX_NAME, new String[0]));
        }

        public static interface Factory {
            public Request create(Map<String, Object> var1, Map<String, Object> var2, Map<String, Object> var3);
        }
    }
}

