/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.apikey;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.action.apikey.AbstractCreateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.ApiKey;
import org.elasticsearch.xpack.core.security.action.apikey.CertificateIdentity;
import org.elasticsearch.xpack.core.security.action.apikey.CrossClusterApiKeyRoleDescriptorBuilder;
import org.elasticsearch.xpack.core.security.action.role.RoleDescriptorRequestValidator;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;

public final class CreateCrossClusterApiKeyRequest
extends AbstractCreateApiKeyRequest {
    private final CertificateIdentity certificateIdentity;

    public CreateCrossClusterApiKeyRequest(String name, CrossClusterApiKeyRoleDescriptorBuilder roleDescriptorBuilder, @Nullable TimeValue expiration, @Nullable Map<String, Object> metadata, @Nullable CertificateIdentity certificateIdentity) {
        this.name = Objects.requireNonNull(name);
        this.roleDescriptors = List.of(roleDescriptorBuilder.build());
        this.expiration = expiration;
        this.metadata = metadata;
        this.certificateIdentity = certificateIdentity;
    }

    @Override
    public ApiKey.Type getType() {
        return ApiKey.Type.CROSS_CLUSTER;
    }

    @Override
    public ActionRequestValidationException validate() {
        if (Assertions.ENABLED) {
            assert (this.roleDescriptors.size() == 1);
            RoleDescriptor roleDescriptor = (RoleDescriptor)this.roleDescriptors.iterator().next();
            CrossClusterApiKeyRoleDescriptorBuilder.validate(roleDescriptor);
            assert (RoleDescriptorRequestValidator.validate(roleDescriptor) == null);
        }
        return super.validate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CreateCrossClusterApiKeyRequest that = (CreateCrossClusterApiKeyRequest)((Object)o);
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.expiration, that.expiration) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.roleDescriptors, that.roleDescriptors) && this.refreshPolicy == that.refreshPolicy && Objects.equals(this.certificateIdentity, that.certificateIdentity);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.expiration, this.metadata, this.roleDescriptors, this.refreshPolicy, this.certificateIdentity);
    }

    public static CreateCrossClusterApiKeyRequest withNameAndAccess(String name, String access) throws IOException {
        return new CreateCrossClusterApiKeyRequest(name, CrossClusterApiKeyRoleDescriptorBuilder.parse(access), null, null, null);
    }

    public CertificateIdentity getCertificateIdentity() {
        return this.certificateIdentity;
    }
}

