/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;

public class TrainedModelCacheMetadata
extends AbstractNamedDiffable<Metadata.ProjectCustom>
implements Metadata.ProjectCustom {
    public static final String NAME = "trained_model_cache_metadata";
    public static final TrainedModelCacheMetadata EMPTY = new TrainedModelCacheMetadata(0L);
    private static final ParseField VERSION_FIELD = new ParseField("version", new String[0]);
    private static final ConstructingObjectParser<TrainedModelCacheMetadata, Void> PARSER = new ConstructingObjectParser("trained_model_cache_metadata", true, args -> new TrainedModelCacheMetadata((Long)args[0]));
    private final long version;

    public static TrainedModelCacheMetadata fromXContent(XContentParser parser) {
        return (TrainedModelCacheMetadata)((Object)PARSER.apply(parser, null));
    }

    public static TrainedModelCacheMetadata fromState(ClusterState clusterState) {
        TrainedModelCacheMetadata cacheMetadata = (TrainedModelCacheMetadata)clusterState.getMetadata().getProject().custom(NAME);
        return cacheMetadata == null ? EMPTY : cacheMetadata;
    }

    public static NamedDiff<Metadata.ProjectCustom> readDiffFrom(StreamInput streamInput) throws IOException {
        return TrainedModelCacheMetadata.readDiffFrom(Metadata.ProjectCustom.class, (String)NAME, (StreamInput)streamInput);
    }

    public TrainedModelCacheMetadata(long version) {
        this.version = version;
    }

    public TrainedModelCacheMetadata(StreamInput in) throws IOException {
        this.version = in.readVLong();
    }

    public long version() {
        return this.version;
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params ignored) {
        return Iterators.single((builder, params) -> builder.field(VERSION_FIELD.getPreferredName(), this.version));
    }

    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.minimumCompatible();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TrainedModelCacheMetadata that = (TrainedModelCacheMetadata)((Object)o);
        return Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.version);
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), VERSION_FIELD);
    }
}

