/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.downsample;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.downsample.DownsampleAction;
import org.elasticsearch.action.downsample.DownsampleConfig;
import org.elasticsearch.action.downsample.DownsampleTask;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.action.support.broadcast.BroadcastShardRequest;
import org.elasticsearch.action.support.broadcast.BroadcastShardResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.downsample.DownsampleShardTask;

public class DownsampleIndexerAction
extends ActionType<Response> {
    public static final DownsampleIndexerAction INSTANCE = new DownsampleIndexerAction();
    public static final String NAME = "indices:admin/xpack/downsample_indexer";

    private DownsampleIndexerAction() {
        super(NAME);
    }

    public static class ShardDownsampleResponse
    extends BroadcastShardResponse {
        private final long numIndexed;

        public ShardDownsampleResponse(ShardId shardId, long numIndexed) {
            super(shardId);
            this.numIndexed = numIndexed;
        }

        public ShardDownsampleResponse(StreamInput in) throws IOException {
            super(in);
            this.numIndexed = in.readLong();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeLong(this.numIndexed);
        }

        public long getNumIndexed() {
            return this.numIndexed;
        }
    }

    public static class ShardDownsampleRequest
    extends BroadcastShardRequest {
        private final Request request;

        public ShardDownsampleRequest(StreamInput in) throws IOException {
            super(in);
            this.request = new Request(in);
        }

        public ShardDownsampleRequest(ShardId shardId, Request request) {
            super(shardId, (BroadcastRequest)request);
            this.request = request;
        }

        public String getDownsampleIndex() {
            return this.request.getDownsampleRequest().getTargetIndex();
        }

        public DownsampleConfig getRollupConfig() {
            return this.request.getDownsampleRequest().getDownsampleConfig();
        }

        public String[] getDimensionFields() {
            return this.request.getDimensionFields();
        }

        public String[] getMetricFields() {
            return this.request.getMetricFields();
        }

        public String[] getLabelFields() {
            return this.request.getLabelFields();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new DownsampleShardTask(id, type, action, parentTaskId, this.request.downsampleRequest.getSourceIndex(), this.request.getIndexStartTimeMillis(), this.request.getIndexEndTimeMillis(), this.request.downsampleRequest.getDownsampleConfig(), headers, this.shardId());
        }
    }

    public static class Response
    extends BroadcastResponse
    implements Writeable {
        private final boolean created;
        private final long numIndexed;

        public Response(boolean created, int totalShards, int successfulShards, int failedShards, long numIndexed) {
            super(totalShards, successfulShards, failedShards, null);
            this.created = created;
            this.numIndexed = numIndexed;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.created = in.readBoolean();
            this.numIndexed = in.readLong();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.created);
            out.writeLong(this.numIndexed);
        }

        public boolean isCreated() {
            return this.created;
        }

        public long getNumIndexed() {
            return this.numIndexed;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("created", this.created);
            builder.field("indexed", this.numIndexed);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response response = (Response)((Object)o);
            if (this.created != response.created) {
                return false;
            }
            return this.numIndexed == response.numIndexed;
        }

        public int hashCode() {
            return Objects.hash(this.created, this.numIndexed);
        }
    }

    public static class Request
    extends BroadcastRequest<Request>
    implements IndicesRequest,
    ToXContentObject {
        private DownsampleAction.Request downsampleRequest;
        private long indexStartTimeMillis;
        private long indexEndTimeMillis;
        private String[] dimensionFields;
        private String[] metricFields;
        private String[] labelFields;

        public Request(DownsampleAction.Request downsampleRequest, long indexStartTimeMillis, long indexEndTimeMillis, String[] dimensionFields, String[] metricFields, String[] labelFields) {
            super(downsampleRequest.indices());
            this.indexStartTimeMillis = indexStartTimeMillis;
            this.indexEndTimeMillis = indexEndTimeMillis;
            this.downsampleRequest = downsampleRequest;
            this.dimensionFields = dimensionFields;
            this.metricFields = metricFields;
            this.labelFields = labelFields;
        }

        public Request() {
            super(new String[0]);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            if (in.readBoolean()) {
                this.indexStartTimeMillis = in.readVLong();
                this.indexEndTimeMillis = in.readVLong();
            } else {
                this.indexStartTimeMillis = 0L;
                this.indexEndTimeMillis = 0L;
            }
            this.downsampleRequest = new DownsampleAction.Request(in);
            this.dimensionFields = in.readStringArray();
            this.metricFields = in.readStringArray();
            this.labelFields = in.readStringArray();
        }

        public String[] indices() {
            return this.downsampleRequest.indices();
        }

        public IndicesOptions indicesOptions() {
            return this.downsampleRequest.indicesOptions();
        }

        public DownsampleAction.Request getDownsampleRequest() {
            return this.downsampleRequest;
        }

        public long getIndexStartTimeMillis() {
            return this.indexStartTimeMillis;
        }

        public long getIndexEndTimeMillis() {
            return this.indexEndTimeMillis;
        }

        public String[] getDimensionFields() {
            return this.dimensionFields;
        }

        public String[] getMetricFields() {
            return this.metricFields;
        }

        public String[] getLabelFields() {
            return this.labelFields;
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new DownsampleTask(id, type, action, parentTaskId, this.downsampleRequest.getTargetIndex(), this.downsampleRequest.getDownsampleConfig(), headers);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(true);
            out.writeVLong(this.indexStartTimeMillis);
            out.writeVLong(this.indexEndTimeMillis);
            this.downsampleRequest.writeTo(out);
            out.writeStringArray(this.dimensionFields);
            out.writeStringArray(this.metricFields);
            out.writeStringArray(this.labelFields);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("downsample_request", (ToXContent)this.downsampleRequest);
            builder.array("dimension_fields", this.dimensionFields);
            builder.array("metric_fields", this.metricFields);
            builder.array("label_fields", this.labelFields);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            int result = this.downsampleRequest.hashCode();
            result = 31 * result + Arrays.hashCode(this.dimensionFields);
            result = 31 * result + Arrays.hashCode(this.metricFields);
            result = 31 * result + Arrays.hashCode(this.labelFields);
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            if (!this.downsampleRequest.equals((Object)request.downsampleRequest)) {
                return false;
            }
            if (!Arrays.equals(this.dimensionFields, request.dimensionFields)) {
                return false;
            }
            if (!Arrays.equals(this.labelFields, request.labelFields)) {
                return false;
            }
            return Arrays.equals(this.metricFields, request.metricFields);
        }
    }
}

