/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.rest.RestStatus;

public class PostStartTrialResponse
extends ActionResponse {
    private final Status status;
    private final Map<String, String[]> acknowledgeMessages;
    private final String acknowledgeMessage;

    PostStartTrialResponse(StreamInput in) throws IOException {
        this.status = (Status)in.readEnum(Status.class);
        this.acknowledgeMessage = in.readOptionalString();
        int size = in.readVInt();
        Map acknowledgeMessages = Maps.newMapWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            String feature = in.readString();
            int nMessages = in.readVInt();
            String[] messages = new String[nMessages];
            for (int j = 0; j < nMessages; ++j) {
                messages[j] = in.readString();
            }
            acknowledgeMessages.put(feature, messages);
        }
        this.acknowledgeMessages = acknowledgeMessages;
    }

    PostStartTrialResponse(Status status) {
        this(status, Collections.emptyMap(), null);
    }

    PostStartTrialResponse(Status status, Map<String, String[]> acknowledgeMessages, String acknowledgeMessage) {
        this.status = status;
        this.acknowledgeMessages = acknowledgeMessages;
        this.acknowledgeMessage = acknowledgeMessage;
    }

    public Status getStatus() {
        return this.status;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.status);
        out.writeOptionalString(this.acknowledgeMessage);
        out.writeMap(this.acknowledgeMessages, StreamOutput::writeStringArray);
    }

    Map<String, String[]> getAcknowledgementMessages() {
        return this.acknowledgeMessages;
    }

    String getAcknowledgementMessage() {
        return this.acknowledgeMessage;
    }

    public static enum Status {
        UPGRADED_TO_TRIAL(true, null, RestStatus.OK),
        TRIAL_ALREADY_ACTIVATED(false, "Operation failed: Trial was already activated.", RestStatus.FORBIDDEN),
        NEED_ACKNOWLEDGEMENT(false, "Operation failed: Needs acknowledgement.", RestStatus.OK);

        private final boolean isTrialStarted;
        private final String errorMessage;
        private final RestStatus restStatus;

        private Status(boolean isTrialStarted, String errorMessage, RestStatus restStatus) {
            this.isTrialStarted = isTrialStarted;
            this.errorMessage = errorMessage;
            this.restStatus = restStatus;
        }

        boolean isTrialStarted() {
            return this.isTrialStarted;
        }

        String getErrorMessage() {
            return this.errorMessage;
        }

        RestStatus getRestStatus() {
            return this.restStatus;
        }
    }
}

