/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.saml;

import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.saml.SamlRealmSettings;
import org.opensaml.saml.saml2.core.Attribute;

class SamlPrivateAttributePredicate
implements Predicate<Attribute> {
    private static final Logger logger = LogManager.getLogger(SamlPrivateAttributePredicate.class);
    private static final Predicate<Attribute> MATCH_NONE = new Predicate<Attribute>(){

        @Override
        public boolean test(Attribute attribute) {
            return false;
        }

        public String toString() {
            return "<matching no SAML private attributes>";
        }
    };
    private final Predicate<Attribute> predicate;

    SamlPrivateAttributePredicate(RealmConfig config) {
        this.predicate = SamlPrivateAttributePredicate.buildPrivateAttributesPredicate(config);
    }

    private static Predicate<Attribute> buildPrivateAttributesPredicate(RealmConfig config) {
        if (!config.hasSetting(SamlRealmSettings.PRIVATE_ATTRIBUTES)) {
            logger.trace("No SAML private attributes setting configured.");
            return MATCH_NONE;
        }
        List attributesList = (List)config.getSetting(SamlRealmSettings.PRIVATE_ATTRIBUTES);
        if (attributesList == null || attributesList.isEmpty()) {
            logger.trace("No SAML private attributes configured for setting [{}].", (Object)SamlRealmSettings.PRIVATE_ATTRIBUTES);
            return MATCH_NONE;
        }
        final Set attributesSet = attributesList.stream().filter(name -> name != null && false == name.isBlank()).collect(Collectors.toUnmodifiableSet());
        if (attributesSet.isEmpty()) {
            return MATCH_NONE;
        }
        logger.trace("SAML private attributes configured: {}", attributesSet);
        return new Predicate<Attribute>(){

            @Override
            public boolean test(Attribute attribute) {
                if (attribute == null) {
                    return false;
                }
                if (attribute.getName() != null && attributesSet.contains(attribute.getName())) {
                    return true;
                }
                return attribute.getFriendlyName() != null && attributesSet.contains(attribute.getFriendlyName());
            }

            public String toString() {
                return "<matching " + String.valueOf(attributesSet) + " SAML private attributes>";
            }
        };
    }

    @Override
    public boolean test(Attribute attribute) {
        return this.predicate.test(attribute);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " {predicate=" + String.valueOf(this.predicate) + "}";
    }
}

