/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.saml;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.action.saml.SamlAuthenticateResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authc.TokenService;
import org.elasticsearch.xpack.security.authc.saml.SamlAuthenticateResponseHandler;

public final class DefaultSamlAuthenticateResponseHandler
implements SamlAuthenticateResponseHandler {
    private final TokenService tokenService;

    public DefaultSamlAuthenticateResponseHandler(TokenService tokenService) {
        this.tokenService = tokenService;
    }

    @Override
    public void handleTokenResponse(Authentication authentication, Authentication originatingAuthentication, AuthenticationResult<User> authenticationResult, ActionListener<SamlAuthenticateResponse> listener) {
        Map tokenMeta = (Map)authenticationResult.getMetadata().get("_xpack_saml_tokendata");
        String inResponseTo = (String)tokenMeta.get("saml_in_response_to");
        this.tokenService.createOAuth2Tokens(authentication, originatingAuthentication, tokenMeta, true, (ActionListener<TokenService.CreateTokenResult>)ActionListener.wrap(tokenResult -> {
            TimeValue expiresIn = this.tokenService.getExpirationDelay();
            listener.onResponse((Object)new SamlAuthenticateResponse(authentication, tokenResult.getAccessToken(), tokenResult.getRefreshToken(), expiresIn, inResponseTo));
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

