/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.util.Map;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.telemetry.metric.MeterRegistry;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.service.ServiceAccountToken;
import org.elasticsearch.xpack.security.authc.Authenticator;
import org.elasticsearch.xpack.security.authc.service.ServiceAccountService;
import org.elasticsearch.xpack.security.metric.InstrumentedSecurityActionListener;
import org.elasticsearch.xpack.security.metric.SecurityMetricType;
import org.elasticsearch.xpack.security.metric.SecurityMetrics;

class ServiceAccountAuthenticator
implements Authenticator {
    public static final String ATTRIBUTE_SERVICE_ACCOUNT_ID = "es_security_service_account_id";
    private static final Logger logger = LogManager.getLogger(ServiceAccountAuthenticator.class);
    private final ServiceAccountService serviceAccountService;
    private final String nodeName;
    private final SecurityMetrics<ServiceAccountToken> authenticationMetrics;

    ServiceAccountAuthenticator(ServiceAccountService serviceAccountService, String nodeName, MeterRegistry meterRegistry) {
        this(serviceAccountService, nodeName, meterRegistry, System::nanoTime);
    }

    ServiceAccountAuthenticator(ServiceAccountService serviceAccountService, String nodeName, MeterRegistry meterRegistry, LongSupplier nanoTimeSupplier) {
        this.serviceAccountService = serviceAccountService;
        this.nodeName = nodeName;
        this.authenticationMetrics = new SecurityMetrics<ServiceAccountToken>(SecurityMetricType.AUTHC_SERVICE_ACCOUNT, meterRegistry, serviceAccountToken -> Map.of(ATTRIBUTE_SERVICE_ACCOUNT_ID, serviceAccountToken.getAccountId().asPrincipal()), nanoTimeSupplier);
    }

    @Override
    public String name() {
        return "service account";
    }

    @Override
    public AuthenticationToken extractCredentials(Authenticator.Context context) {
        SecureString bearerString = context.getBearerString();
        if (bearerString == null) {
            return null;
        }
        return ServiceAccountService.tryParseToken(bearerString);
    }

    @Override
    public void authenticate(Authenticator.Context context, ActionListener<AuthenticationResult<Authentication>> listener) {
        AuthenticationToken authenticationToken = context.getMostRecentAuthenticationToken();
        if (!(authenticationToken instanceof ServiceAccountToken)) {
            listener.onResponse((Object)AuthenticationResult.notHandled());
            return;
        }
        ServiceAccountToken serviceAccountToken = (ServiceAccountToken)authenticationToken;
        this.doAuthenticate(context, serviceAccountToken, InstrumentedSecurityActionListener.wrapForAuthc(this.authenticationMetrics, serviceAccountToken, listener));
    }

    private void doAuthenticate(Authenticator.Context context, ServiceAccountToken serviceAccountToken, ActionListener<AuthenticationResult<Authentication>> listener) {
        this.serviceAccountService.authenticateToken(serviceAccountToken, this.nodeName, (ActionListener<Authentication>)ActionListener.wrap(authentication -> {
            assert (authentication != null) : "service account authenticate should return either authentication or call onFailure";
            listener.onResponse((Object)AuthenticationResult.success((Object)authentication));
        }, e -> {
            logger.debug(() -> "Failed to validate service account token for request [" + String.valueOf(context.getRequest()) + "]", (Throwable)e);
            listener.onFailure((Exception)((Object)context.getRequest().exceptionProcessingRequest((Exception)e, (AuthenticationToken)serviceAccountToken)));
        }));
    }
}

