/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.telemetry.metric.MeterRegistry;
import org.elasticsearch.xpack.core.common.IteratingActionListener;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.Realm;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authc.Authenticator;
import org.elasticsearch.xpack.security.authc.support.RealmUserLookup;
import org.elasticsearch.xpack.security.metric.InstrumentedSecurityActionListener;
import org.elasticsearch.xpack.security.metric.SecurityMetricType;
import org.elasticsearch.xpack.security.metric.SecurityMetrics;

public class RealmsAuthenticator
implements Authenticator {
    public static final String ATTRIBUTE_REALM_NAME = "es_security_realm_name";
    public static final String ATTRIBUTE_REALM_TYPE = "es_security_realm_type";
    private static final Logger logger = LogManager.getLogger(RealmsAuthenticator.class);
    private final AtomicLong numInvalidation;
    private final Cache<String, Realm> lastSuccessfulAuthCache;
    private final SecurityMetrics<Realm> authenticationMetrics;

    public RealmsAuthenticator(AtomicLong numInvalidation, Cache<String, Realm> lastSuccessfulAuthCache, MeterRegistry meterRegistry) {
        this(numInvalidation, lastSuccessfulAuthCache, meterRegistry, System::nanoTime);
    }

    RealmsAuthenticator(AtomicLong numInvalidation, Cache<String, Realm> lastSuccessfulAuthCache, MeterRegistry meterRegistry, LongSupplier nanoTimeSupplier) {
        this.numInvalidation = numInvalidation;
        this.lastSuccessfulAuthCache = lastSuccessfulAuthCache;
        this.authenticationMetrics = new SecurityMetrics<Realm>(SecurityMetricType.AUTHC_REALMS, meterRegistry, realm -> Map.ofEntries(Map.entry(ATTRIBUTE_REALM_NAME, realm.name()), Map.entry(ATTRIBUTE_REALM_TYPE, realm.type())), nanoTimeSupplier);
    }

    @Override
    public String name() {
        return "realms";
    }

    @Override
    public AuthenticationToken extractCredentials(Authenticator.Context context) {
        AuthenticationToken authenticationToken = RealmsAuthenticator.extractToken(context);
        if (authenticationToken != null) {
            context.setHandleNullToken(false);
        }
        return authenticationToken;
    }

    @Override
    public void authenticate(Authenticator.Context context, ActionListener<AuthenticationResult<Authentication>> listener) {
        if (context.getMostRecentAuthenticationToken() == null) {
            listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("authentication token must present for realms authentication", RestStatus.UNAUTHORIZED, new Object[0])));
            return;
        }
        assert (context.getMostRecentAuthenticationToken() != null) : "null token should be handled by fallback authenticator";
        this.consumeToken(context, listener);
    }

    static AuthenticationToken extractToken(Authenticator.Context context) {
        try {
            for (Realm realm : context.getDefaultOrderedRealmList()) {
                AuthenticationToken token = realm.token(context.getThreadContext());
                if (token == null) continue;
                logger.trace("Found authentication credentials [{}] for principal [{}] in request [{}]", (Object)token.getClass().getName(), (Object)token.principal(), (Object)context.getRequest());
                return token;
            }
        }
        catch (Exception e) {
            logger.warn("An exception occurred while attempting to find authentication credentials", (Throwable)e);
            throw context.getRequest().exceptionProcessingRequest(e, null);
        }
        if (!context.getUnlicensedRealms().isEmpty()) {
            logger.warn("No authentication credential could be extracted using realms [{}]. Realms [{}] were skipped because they are not permitted on the current license", (Object)org.elasticsearch.common.Strings.collectionToCommaDelimitedString(context.getDefaultOrderedRealmList()), (Object)org.elasticsearch.common.Strings.collectionToCommaDelimitedString(context.getUnlicensedRealms()));
        }
        return null;
    }

    private void consumeToken(Authenticator.Context context, ActionListener<AuthenticationResult<Authentication>> listener) {
        AuthenticationToken authenticationToken = context.getMostRecentAuthenticationToken();
        List<Realm> realmsList = this.getRealmList(context, authenticationToken.principal());
        logger.trace("Checking token of type [{}] against [{}] realm(s)", (Object)authenticationToken.getClass().getName(), (Object)realmsList.size());
        long startInvalidation = this.numInvalidation.get();
        LinkedHashMap messages = new LinkedHashMap();
        AtomicReference authenticatedByRef = new AtomicReference();
        AtomicReference authenticationResultRef = new AtomicReference();
        BiConsumer<Realm, ActionListener> realmAuthenticatingConsumer = (realm, userListener) -> {
            if (realm.supports(authenticationToken)) {
                logger.trace("Trying to authenticate [{}] using realm [{}] with token [{}] ", (Object)authenticationToken.principal(), realm, (Object)authenticationToken.getClass().getName());
                realm.authenticate(authenticationToken, InstrumentedSecurityActionListener.wrapForAuthc(this.authenticationMetrics, realm, ActionListener.wrap(result -> {
                    assert (result != null) : "Realm " + String.valueOf(realm) + " produced a null authentication result";
                    logger.debug("Authentication of [{}] using realm [{}] with token [{}] was [{}]", (Object)authenticationToken.principal(), realm, (Object)authenticationToken.getClass().getSimpleName(), result);
                    if (result.getStatus() == AuthenticationResult.Status.SUCCESS) {
                        authenticatedByRef.set(realm);
                        authenticationResultRef.set(result);
                        if (this.lastSuccessfulAuthCache != null && startInvalidation == this.numInvalidation.get()) {
                            this.lastSuccessfulAuthCache.put((Object)authenticationToken.principal(), realm);
                        }
                        userListener.onResponse((Object)((User)result.getValue()));
                    } else {
                        context.getRequest().realmAuthenticationFailed(authenticationToken, realm.name());
                        if (result.getStatus() == AuthenticationResult.Status.TERMINATE) {
                            Exception resultException = result.getException();
                            if (resultException != null) {
                                logger.info(() -> Strings.format((String)"Authentication of [%s] was terminated by realm [%s] - %s", (Object[])new Object[]{authenticationToken.principal(), realm.name(), result.getMessage()}), (Throwable)resultException);
                                userListener.onFailure(resultException);
                            } else {
                                logger.info("Authentication of [{}] was terminated by realm [{}] - {}", (Object)authenticationToken.principal(), (Object)realm.name(), (Object)result.getMessage());
                                userListener.onFailure((Exception)AuthenticationTerminatedSuccessfullyException.INSTANCE);
                            }
                        } else {
                            if (result.getMessage() != null) {
                                messages.put(realm, new Tuple((Object)result.getMessage(), (Object)result.getException()));
                            }
                            userListener.onResponse(null);
                        }
                    }
                }, ex -> {
                    logger.warn(() -> Strings.format((String)"An error occurred while attempting to authenticate [%s] against realm [%s]", (Object[])new Object[]{authenticationToken.principal(), realm.name()}), (Throwable)ex);
                    userListener.onFailure(ex);
                })));
            } else {
                userListener.onResponse(null);
            }
        };
        IteratingActionListener authenticatingListener = new IteratingActionListener((ActionListener)ContextPreservingActionListener.wrapPreservingContext((ActionListener)ActionListener.wrap(user -> {
            if (user == null) {
                RealmsAuthenticator.consumeNullUser(context, messages, listener);
            } else {
                AuthenticationResult result = (AuthenticationResult)authenticationResultRef.get();
                assert (result != null) : "authentication result must not be null when user is not null";
                AuthenticationResult.THREAD_CONTEXT_VALUE.set(context.getThreadContext(), (Object)result);
                listener.onResponse((Object)AuthenticationResult.success((Object)Authentication.newRealmAuthentication((User)user, (Authentication.RealmRef)((Realm)authenticatedByRef.get()).realmRef())));
            }
        }, e -> {
            if (e == AuthenticationTerminatedSuccessfullyException.INSTANCE) {
                listener.onFailure((Exception)((Object)context.getRequest().authenticationFailed(authenticationToken)));
            } else {
                assert (!(e instanceof AuthenticationTerminatedSuccessfullyException)) : e;
                logger.debug(() -> Strings.format((String)"An error occurred while attempting to authenticate [%s] with token of type [%s]", (Object[])new Object[]{authenticationToken.principal(), authenticationToken.getClass().getName()}), (Throwable)e);
                listener.onFailure((Exception)((Object)context.getRequest().exceptionProcessingRequest((Exception)e, authenticationToken)));
            }
        }), (ThreadContext)context.getThreadContext()), realmAuthenticatingConsumer, realmsList, context.getThreadContext());
        try {
            authenticatingListener.run();
        }
        catch (Exception e2) {
            logger.debug(() -> Strings.format((String)"Authentication of [%s] with token of type [%s] failed", (Object[])new Object[]{authenticationToken.principal(), authenticationToken.getClass().getName()}), (Throwable)e2);
            listener.onFailure((Exception)((Object)context.getRequest().exceptionProcessingRequest(e2, authenticationToken)));
        }
    }

    private static void consumeNullUser(Authenticator.Context context, Map<Realm, Tuple<String, Exception>> messages, ActionListener<AuthenticationResult<Authentication>> listener) {
        messages.forEach((realm, tuple) -> {
            String message = (String)tuple.v1();
            StringBuilder cause = new StringBuilder();
            for (Throwable ex = (Throwable)tuple.v2(); ex != null; ex = ex.getCause()) {
                cause.append(cause.isEmpty() ? " (" : "; ");
                cause.append("Caused by ").append(ex);
            }
            if (!cause.isEmpty()) {
                cause.append(')');
            }
            logger.warn("Authentication to realm {} failed - {}{}", (Object)realm.name(), (Object)message, (Object)cause);
        });
        if (!context.getUnlicensedRealms().isEmpty()) {
            logger.warn("Authentication failed using realms [{}]. Realms [{}] were skipped because they are not permitted on the current license", (Object)org.elasticsearch.common.Strings.collectionToCommaDelimitedString(context.getDefaultOrderedRealmList()), (Object)org.elasticsearch.common.Strings.collectionToCommaDelimitedString(context.getUnlicensedRealms()));
        }
        logger.trace("Failed to authenticate request [{}]", (Object)context.getRequest());
        listener.onFailure((Exception)((Object)context.getRequest().authenticationFailed(context.getMostRecentAuthenticationToken())));
    }

    public void lookupRunAsUser(Authenticator.Context context, Authentication authentication, ActionListener<Tuple<User, Realm>> listener) {
        assert (!authentication.isRunAs()) : "authentication already has run-as";
        String runAsUsername = context.getThreadContext().getHeader("es-security-runas-user");
        if (runAsUsername != null && !runAsUsername.isEmpty()) {
            logger.trace("Looking up run-as user [{}] for authenticated user [{}]", (Object)runAsUsername, (Object)authentication.getAuthenticatingSubject().getUser().principal());
            RealmUserLookup lookup = new RealmUserLookup(this.getRealmList(context, runAsUsername), context.getThreadContext());
            long startInvalidationNum = this.numInvalidation.get();
            lookup.lookup(runAsUsername, (ActionListener<Tuple<User, Realm>>)ActionListener.wrap(tuple -> {
                if (tuple == null) {
                    logger.debug("Cannot find run-as user [{}] for authenticated user [{}]", (Object)runAsUsername, (Object)authentication.getAuthenticatingSubject().getUser().principal());
                    listener.onResponse(null);
                } else {
                    User foundUser = Objects.requireNonNull((User)tuple.v1());
                    Realm realm = Objects.requireNonNull((Realm)tuple.v2());
                    if (this.lastSuccessfulAuthCache != null && startInvalidationNum == this.numInvalidation.get()) {
                        this.lastSuccessfulAuthCache.computeIfAbsent((Object)runAsUsername, s -> realm);
                    }
                    logger.trace("Using run-as user [{}] with authenticated user [{}]", (Object)foundUser, (Object)authentication.getAuthenticatingSubject().getUser().principal());
                    listener.onResponse(tuple);
                }
            }, e -> {
                logger.debug(() -> Strings.format((String)"An error occurred while looking up run-as user [%s] for authenticated user [%s]", (Object[])new Object[]{runAsUsername, authentication.getAuthenticatingSubject().getUser().principal()}), (Throwable)e);
                listener.onFailure((Exception)((Object)context.getRequest().exceptionProcessingRequest((Exception)e, context.getMostRecentAuthenticationToken())));
            }));
        } else if (runAsUsername == null) {
            listener.onResponse(null);
        } else {
            logger.debug("user [{}] attempted to runAs with an empty username", (Object)authentication.getAuthenticatingSubject().getUser().principal());
            listener.onFailure((Exception)((Object)context.getRequest().runAsDenied(authentication.runAs(new User(runAsUsername, new String[0]), null), context.getMostRecentAuthenticationToken())));
        }
    }

    private List<Realm> getRealmList(Authenticator.Context context, String principal) {
        int index;
        Realm lastSuccess;
        List<Realm> orderedRealmList = context.getDefaultOrderedRealmList();
        if (this.lastSuccessfulAuthCache != null && (lastSuccess = (Realm)this.lastSuccessfulAuthCache.get((Object)principal)) != null && (index = orderedRealmList.indexOf(lastSuccess)) > 0) {
            ArrayList<Realm> smartOrder = new ArrayList<Realm>(orderedRealmList.size());
            smartOrder.add(lastSuccess);
            for (int i = 0; i < orderedRealmList.size(); ++i) {
                if (i == index) continue;
                smartOrder.add(orderedRealmList.get(i));
            }
            assert (smartOrder.size() == orderedRealmList.size() && smartOrder.containsAll(orderedRealmList)) : "Element mismatch between SmartOrder=" + String.valueOf(smartOrder) + " and DefaultOrder=" + String.valueOf(orderedRealmList);
            return Collections.unmodifiableList(smartOrder);
        }
        return orderedRealmList;
    }

    private static class AuthenticationTerminatedSuccessfullyException
    extends Exception {
        static AuthenticationTerminatedSuccessfullyException INSTANCE = new AuthenticationTerminatedSuccessfullyException();

        private AuthenticationTerminatedSuccessfullyException() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

