/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.TriConsumer;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.env.Environment;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.security.authc.Realm;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.support.UserRoleMapper;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.authc.esnative.NativeRealm;
import org.elasticsearch.xpack.security.authc.esnative.NativeUsersStore;
import org.elasticsearch.xpack.security.authc.file.FileRealm;
import org.elasticsearch.xpack.security.authc.jwt.JwtRealm;
import org.elasticsearch.xpack.security.authc.kerberos.KerberosRealm;
import org.elasticsearch.xpack.security.authc.ldap.LdapRealm;
import org.elasticsearch.xpack.security.authc.oidc.OpenIdConnectRealm;
import org.elasticsearch.xpack.security.authc.pki.PkiRealm;
import org.elasticsearch.xpack.security.authc.saml.SamlRealm;
import org.elasticsearch.xpack.security.authc.saml.SingleSamlSpConfiguration;
import org.elasticsearch.xpack.security.authc.support.RoleMappingFileBootstrapCheck;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;

public final class InternalRealms {
    static final String RESERVED_TYPE = "reserved";
    static final String NATIVE_TYPE = "native";
    static final String FILE_TYPE = "file";
    static final String LDAP_TYPE = "ldap";
    static final String AD_TYPE = "active_directory";
    static final String PKI_TYPE = "pki";
    static final String SAML_TYPE = "saml";
    static final String OIDC_TYPE = "oidc";
    static final String JWT_TYPE = "jwt";
    static final String KERBEROS_TYPE = "kerberos";
    private static final Set<String> BUILTIN_TYPES = Set.of("native", "file");
    private static final Map<String, LicensedFeature.Persistent> LICENSED_REALMS;

    @Deprecated
    public static Collection<String> getConfigurableRealmsTypes() {
        return Set.copyOf(Sets.union(BUILTIN_TYPES, LICENSED_REALMS.keySet()));
    }

    static boolean isInternalRealm(String type) {
        return RESERVED_TYPE.equals(type) || BUILTIN_TYPES.contains(type) || LICENSED_REALMS.containsKey(type);
    }

    static boolean isBuiltinRealm(String type) {
        return BUILTIN_TYPES.contains(type);
    }

    @Nullable
    static LicensedFeature.Persistent getLicensedFeature(String type) {
        if (Strings.isNullOrEmpty((String)type)) {
            throw new IllegalArgumentException("Empty realm type [" + type + "]");
        }
        if (type.equals(RESERVED_TYPE) || InternalRealms.isBuiltinRealm(type)) {
            return null;
        }
        LicensedFeature.Persistent feature = LICENSED_REALMS.get(type);
        if (feature == null) {
            throw new IllegalArgumentException("Unsupported realm type [" + type + "]");
        }
        return feature;
    }

    public static Map<String, Realm.Factory> getFactories(ThreadPool threadPool, Settings settings, ResourceWatcherService resourceWatcherService, SSLService sslService, NativeUsersStore nativeUsersStore, UserRoleMapper userRoleMapper, SecurityIndexManager securityIndex) {
        return Map.of(FILE_TYPE, config -> new FileRealm(config, resourceWatcherService, threadPool), NATIVE_TYPE, config -> InternalRealms.buildNativeRealm(threadPool, settings, nativeUsersStore, securityIndex, config), AD_TYPE, config -> new LdapRealm(config, sslService, resourceWatcherService, userRoleMapper, threadPool), LDAP_TYPE, config -> new LdapRealm(config, sslService, resourceWatcherService, userRoleMapper, threadPool), PKI_TYPE, config -> new PkiRealm(config, resourceWatcherService, userRoleMapper), SAML_TYPE, config -> SamlRealm.create(config, sslService, resourceWatcherService, userRoleMapper, SingleSamlSpConfiguration.create(config)), KERBEROS_TYPE, config -> new KerberosRealm(config, userRoleMapper, threadPool), OIDC_TYPE, config -> new OpenIdConnectRealm(config, sslService, userRoleMapper, resourceWatcherService), JWT_TYPE, config -> new JwtRealm(config, sslService, userRoleMapper, threadPool));
    }

    private static NativeRealm buildNativeRealm(ThreadPool threadPool, Settings settings, NativeUsersStore nativeUsersStore, SecurityIndexManager securityIndex, RealmConfig config) {
        if (!settings.getAsBoolean("xpack.security.authc.native_users.enabled", Boolean.valueOf(true)).booleanValue()) {
            throw new IllegalArgumentException("Cannot configure a [native] realm when [xpack.security.authc.native_users.enabled] is false");
        }
        NativeRealm nativeRealm = new NativeRealm(config, nativeUsersStore, threadPool);
        securityIndex.addStateListener((TriConsumer<ProjectId, SecurityIndexManager.IndexState, SecurityIndexManager.IndexState>)((TriConsumer)nativeRealm::onSecurityIndexStateChange));
        return nativeRealm;
    }

    private InternalRealms() {
    }

    public static List<BootstrapCheck> getBootstrapChecks(Settings globalSettings, Environment env) {
        HashSet realmTypes = Sets.newHashSet((Object[])new String[]{AD_TYPE, LDAP_TYPE, PKI_TYPE});
        return RealmSettings.getRealmSettings((Settings)globalSettings).keySet().stream().filter(id -> realmTypes.contains(id.getType())).map(id -> new RealmConfig(id, globalSettings, env, null)).map(RoleMappingFileBootstrapCheck::create).filter(Objects::nonNull).toList();
    }

    static {
        HashMap<String, LicensedFeature.Persistent> realms = new HashMap<String, LicensedFeature.Persistent>();
        realms.put(AD_TYPE, Security.AD_REALM_FEATURE);
        realms.put(LDAP_TYPE, Security.LDAP_REALM_FEATURE);
        realms.put(PKI_TYPE, Security.PKI_REALM_FEATURE);
        realms.put(SAML_TYPE, Security.SAML_REALM_FEATURE);
        realms.put(KERBEROS_TYPE, Security.KERBEROS_REALM_FEATURE);
        realms.put(OIDC_TYPE, Security.OIDC_REALM_FEATURE);
        realms.put(JWT_TYPE, Security.JWT_REALM_FEATURE);
        LICENSED_REALMS = Map.copyOf(realms);
    }
}

