/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.security.action.apikey.ApiKey;
import org.elasticsearch.xpack.core.security.authc.CrossClusterAccessSubjectInfo;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.transport.CrossClusterApiKeySignatureManager;
import org.elasticsearch.xpack.security.transport.X509CertificateSignature;

public final class CrossClusterAccessHeaders {
    public static final String CROSS_CLUSTER_ACCESS_CREDENTIALS_HEADER_KEY = "_cross_cluster_access_credentials";
    private final String credentialsHeader;
    private final CrossClusterAccessSubjectInfo crossClusterAccessSubjectInfo;
    private final X509CertificateSignature signature;
    private final String[] signablePayload;

    public CrossClusterAccessHeaders(String credentialsHeader, CrossClusterAccessSubjectInfo crossClusterAccessSubjectInfo) {
        this(credentialsHeader, crossClusterAccessSubjectInfo, null, new String[0]);
    }

    private CrossClusterAccessHeaders(String credentialsHeader, CrossClusterAccessSubjectInfo crossClusterAccessSubjectInfo, @Nullable X509CertificateSignature signature, String ... signablePayload) {
        assert (credentialsHeader.startsWith("ApiKey ")) : "credentials header must start with [ApiKey ]";
        this.credentialsHeader = credentialsHeader;
        this.crossClusterAccessSubjectInfo = crossClusterAccessSubjectInfo;
        this.signature = signature;
        this.signablePayload = signablePayload;
    }

    public void writeToContext(ThreadContext ctx, @Nullable CrossClusterApiKeySignatureManager.Signer signer) throws IOException {
        String encodedSubjectInfo = this.crossClusterAccessSubjectInfo.encode();
        if (signer != null) {
            X509CertificateSignature signature = signer.sign(encodedSubjectInfo, this.credentialsHeader);
            X509CertificateSignature.writeToContext(ctx, signature);
        }
        ctx.putHeader("_cross_cluster_access_subject_info", encodedSubjectInfo);
        ctx.putHeader(CROSS_CLUSTER_ACCESS_CREDENTIALS_HEADER_KEY, this.credentialsHeader);
    }

    public static CrossClusterAccessHeaders readFromContext(ThreadContext ctx) throws IOException {
        String credentialsHeader = ctx.getHeader(CROSS_CLUSTER_ACCESS_CREDENTIALS_HEADER_KEY);
        if (credentialsHeader == null) {
            throw new IllegalArgumentException("cross cluster access header [_cross_cluster_access_credentials] is required");
        }
        CrossClusterAccessHeaders.parseCredentialsHeader(credentialsHeader).close();
        String subjectInfoHeader = ctx.getHeader("_cross_cluster_access_subject_info");
        if (subjectInfoHeader == null) {
            throw new IllegalArgumentException("cross cluster access header [_cross_cluster_access_subject_info] is required");
        }
        CrossClusterAccessSubjectInfo subjectInfo = CrossClusterAccessSubjectInfo.decode((String)subjectInfoHeader);
        return new CrossClusterAccessHeaders(credentialsHeader, subjectInfo, X509CertificateSignature.readFromContext(ctx), subjectInfoHeader, credentialsHeader);
    }

    public ApiKeyService.ApiKeyCredentials credentials() {
        return CrossClusterAccessHeaders.parseCredentialsHeader(this.credentialsHeader, CrossClusterAccessHeaders.getCertificateIdentity(this.signature));
    }

    public static String getCertificateIdentity(X509CertificateSignature signature) {
        if (signature != null) {
            if (signature.certificates().length == 0) {
                throw new IllegalArgumentException("Provided signature does not contain any certificates");
            }
            return signature.leafCertificate().getSubjectX500Principal().getName("RFC2253");
        }
        return null;
    }

    public X509CertificateSignature signature() {
        return this.signature;
    }

    public String[] signablePayload() {
        return this.signablePayload;
    }

    static ApiKeyService.ApiKeyCredentials parseCredentialsHeader(String credentialsHeader) {
        return CrossClusterAccessHeaders.parseCredentialsHeader(credentialsHeader, null);
    }

    static ApiKeyService.ApiKeyCredentials parseCredentialsHeader(String header, @Nullable String expectedCertificateIdentity) {
        try {
            return Objects.requireNonNull(ApiKeyService.getCredentialsFromHeader(header, expectedCertificateIdentity, ApiKey.Type.CROSS_CLUSTER));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("cross cluster access header [_cross_cluster_access_credentials] value must be a valid API key credential", ex);
        }
    }

    public CrossClusterAccessSubjectInfo getCleanAndValidatedSubjectInfo() {
        return this.crossClusterAccessSubjectInfo.cleanAndValidate();
    }

    CrossClusterAccessSubjectInfo getSubjectInfo() {
        return this.crossClusterAccessSubjectInfo;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CrossClusterAccessHeaders that = (CrossClusterAccessHeaders)obj;
        return Objects.equals(this.credentialsHeader, that.credentialsHeader) && Objects.equals(this.crossClusterAccessSubjectInfo, that.crossClusterAccessSubjectInfo) && Objects.equals(this.signature, that.signature) && Arrays.equals(this.signablePayload, that.signablePayload);
    }

    public int hashCode() {
        return Objects.hash(this.credentialsHeader, this.crossClusterAccessSubjectInfo, this.signature, Arrays.hashCode(this.signablePayload));
    }
}

