/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.settings;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.LinkedProjectConfig;
import org.elasticsearch.transport.RemoteClusterCredentialsManager;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.RemoteClusterSettings;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.xpack.core.security.action.ActionTypes;

public class TransportReloadRemoteClusterCredentialsAction
extends TransportAction<Request, ActionResponse.Empty> {
    private static final Logger logger = LogManager.getLogger(TransportReloadRemoteClusterCredentialsAction.class);
    private final RemoteClusterService remoteClusterService;
    private final ClusterService clusterService;
    private final ProjectResolver projectResolver;

    @Inject
    public TransportReloadRemoteClusterCredentialsAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, ProjectResolver projectResolver) {
        super(ActionTypes.RELOAD_REMOTE_CLUSTER_CREDENTIALS_ACTION.name(), actionFilters, transportService.getTaskManager(), (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.remoteClusterService = transportService.getRemoteClusterService();
        this.clusterService = clusterService;
        this.projectResolver = projectResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(Task task, Request request, ActionListener<ActionResponse.Empty> listener) {
        assert (Transports.assertNotTransportThread((String)"Remote connection re-building is too much for a transport thread"));
        ClusterState clusterState = this.clusterService.state();
        ClusterBlockException clusterBlockException = this.checkBlock(clusterState);
        if (clusterBlockException != null) {
            throw clusterBlockException;
        }
        Supplier<Settings> settingsSupplier = () -> {
            Settings persistentSettings = clusterState.metadata().persistentSettings();
            Settings transientSettings = clusterState.metadata().transientSettings();
            return Settings.builder().put(request.getSettings(), true).put(persistentSettings, false).put(transientSettings, false).build();
        };
        RemoteClusterService remoteClusterService = this.remoteClusterService;
        synchronized (remoteClusterService) {
            this.updateClusterCredentials(settingsSupplier, listener);
        }
    }

    private void updateClusterCredentials(Supplier<Settings> settingsSupplier, ActionListener<ActionResponse.Empty> listener) {
        ProjectId projectId = this.projectResolver.getProjectId();
        RemoteClusterCredentialsManager credentialsManager = this.remoteClusterService.getRemoteClusterCredentialsManager();
        Settings staticSettings = this.clusterService.getSettings();
        Settings newSettings = settingsSupplier.get();
        RemoteClusterCredentialsManager.UpdateRemoteClusterCredentialsResult result = credentialsManager.updateClusterCredentials(newSettings);
        int totalConnectionsToRebuild = result.addedClusterAliases().size() + result.removedClusterAliases().size();
        if (totalConnectionsToRebuild == 0) {
            logger.debug("project [{}] no connection rebuilding required after credentials update", (Object)projectId);
            listener.onResponse((Object)ActionResponse.Empty.INSTANCE);
            return;
        }
        logger.info("project [{}] rebuilding [{}] connections after credentials update", (Object)projectId, (Object)totalConnectionsToRebuild);
        try (RefCountingRunnable connectionRefs = new RefCountingRunnable(() -> listener.onResponse((Object)ActionResponse.Empty.INSTANCE));){
            Settings mergedSettings = Settings.builder().put(staticSettings, false).put(newSettings, false).build();
            for (String clusterAlias : result.addedClusterAliases()) {
                this.maybeRebuildConnectionOnCredentialsChange(projectId, clusterAlias, mergedSettings, connectionRefs);
            }
            for (String clusterAlias : result.removedClusterAliases()) {
                this.maybeRebuildConnectionOnCredentialsChange(projectId, clusterAlias, mergedSettings, connectionRefs);
            }
        }
    }

    private void maybeRebuildConnectionOnCredentialsChange(final ProjectId projectId, final String clusterAlias, Settings mergedSettings, RefCountingRunnable connectionRefs) {
        if (!this.remoteClusterService.getRegisteredRemoteClusterNames(projectId).contains(clusterAlias)) {
            logger.info("project [{}] no connection rebuild required for remote cluster [{}] after credentials change", (Object)projectId, (Object)clusterAlias);
            return;
        }
        if (!RemoteClusterSettings.isConnectionEnabled((String)clusterAlias, (Settings)mergedSettings)) {
            logger.info("project [{}] remote cluster connection [{}] not enabled after credentials change", (Object)projectId, (Object)clusterAlias);
            this.remoteClusterService.remove(projectId, ProjectId.DEFAULT, clusterAlias);
            return;
        }
        LinkedProjectConfig config = this.toConfig(projectId, clusterAlias, mergedSettings);
        this.remoteClusterService.updateRemoteCluster(config, true, ActionListener.releaseAfter((ActionListener)new ActionListener<RemoteClusterService.RemoteClusterConnectionStatus>(this){

            public void onResponse(RemoteClusterService.RemoteClusterConnectionStatus status) {
                logger.info("project [{}] remote cluster connection [{}] updated after credentials change: [{}]", (Object)projectId, (Object)clusterAlias, (Object)status);
            }

            public void onFailure(Exception e) {
                logger.warn(() -> "project [" + String.valueOf(projectId) + "] failed to update remote cluster connection [" + clusterAlias + "] after credentials change", (Throwable)e);
            }
        }, (Releasable)connectionRefs.acquire()));
    }

    private LinkedProjectConfig toConfig(ProjectId projectId, String clusterAlias, Settings mergedSettings) {
        return RemoteClusterSettings.toConfig((ProjectId)projectId, (ProjectId)ProjectId.DEFAULT, (String)clusterAlias, (Settings)mergedSettings);
    }

    private ClusterBlockException checkBlock(ClusterState clusterState) {
        return clusterState.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    public static class Request
    extends LegacyActionRequest {
        private final Settings settings;

        public Request(Settings settings) {
            this.settings = settings;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public Settings getSettings() {
            return this.settings;
        }

        public void writeTo(StreamOutput out) throws IOException {
            TransportAction.localOnly();
        }
    }
}

