/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.SequentialAckingBatchedTaskExecutor;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.metadata.View;
import org.elasticsearch.cluster.metadata.ViewMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.xpack.esql.VerificationException;
import org.elasticsearch.xpack.esql.expression.function.EsqlFunctionRegistry;
import org.elasticsearch.xpack.esql.inference.InferenceSettings;
import org.elasticsearch.xpack.esql.parser.EsqlParser;
import org.elasticsearch.xpack.esql.parser.QueryParams;
import org.elasticsearch.xpack.esql.plan.IndexPattern;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.UnionAll;
import org.elasticsearch.xpack.esql.plan.logical.UnresolvedRelation;
import org.elasticsearch.xpack.esql.plugin.EsqlFeatures;
import org.elasticsearch.xpack.esql.telemetry.PlanTelemetry;
import org.elasticsearch.xpack.esql.view.DeleteViewAction;
import org.elasticsearch.xpack.esql.view.PutViewAction;

public class ViewService {
    private static final Logger logger = LogManager.getLogger(ViewService.class);
    private static final InferenceSettings EMPTY_INFERENCE_SETTINGS = new InferenceSettings(Settings.EMPTY);
    private final PlanTelemetry telemetry;
    private final ClusterService clusterService;
    private final ProjectResolver projectResolver;
    private final MasterServiceTaskQueue<AckedClusterStateUpdateTask> taskQueue;
    public static final Setting<Integer> MAX_VIEWS_COUNT_SETTING = Setting.intSetting((String)"esql.views.max_count", (int)100, (int)0, (int)1000000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Integer> MAX_VIEW_LENGTH_SETTING = Setting.intSetting((String)"esql.views.max_view_length", (int)10000, (int)1, (int)1000000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Integer> MAX_VIEW_DEPTH_SETTING = Setting.intSetting((String)"esql.views.max_view_depth", (int)10, (int)0, (int)100, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private volatile int maxViewsCount;
    private volatile int maxViewLength;
    private volatile int maxViewDepth;

    public ViewService(ClusterService clusterService, ProjectResolver projectResolver, Settings settings) {
        this.clusterService = clusterService;
        this.projectResolver = projectResolver;
        this.taskQueue = clusterService.createTaskQueue("update-esql-view-metadata", Priority.NORMAL, (ClusterStateTaskExecutor)new SequentialAckingBatchedTaskExecutor());
        this.telemetry = new PlanTelemetry(new EsqlFunctionRegistry());
        this.maxViewsCount = (Integer)MAX_VIEWS_COUNT_SETTING.get(settings);
        this.maxViewLength = (Integer)MAX_VIEW_LENGTH_SETTING.get(settings);
        this.maxViewDepth = (Integer)MAX_VIEW_DEPTH_SETTING.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_VIEWS_COUNT_SETTING, i -> {
            this.maxViewsCount = i;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_VIEW_LENGTH_SETTING, i -> {
            this.maxViewLength = i;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_VIEW_DEPTH_SETTING, i -> {
            this.maxViewDepth = i;
        });
    }

    ViewMetadata getMetadata() {
        return this.getMetadata(this.projectResolver.getProjectId());
    }

    protected ViewMetadata getMetadata(ProjectMetadata projectMetadata) {
        return (ViewMetadata)projectMetadata.custom("esql_view", (Metadata.ProjectCustom)ViewMetadata.EMPTY);
    }

    ViewMetadata getMetadata(ProjectId projectId) {
        return this.getMetadata(this.clusterService.state().metadata().getProject(projectId));
    }

    public void putView(final ProjectId projectId, PutViewAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        if (!this.viewsFeatureEnabled()) {
            listener.onFailure((Exception)new IllegalArgumentException("ESQL views are not enabled"));
            return;
        }
        final View view = request.view();
        final ProjectMetadata metadata = this.clusterService.state().metadata().getProject(projectId);
        try {
            this.validatePutView(metadata, view);
        }
        catch (Exception e) {
            listener.onFailure(e);
            return;
        }
        View existingView = (View)this.getMetadata(metadata).views().get(view.name());
        if (view.equals((Object)existingView)) {
            listener.onResponse((Object)AcknowledgedResponse.TRUE);
            return;
        }
        AckedClusterStateUpdateTask task = new AckedClusterStateUpdateTask(request, listener){

            public ClusterState execute(ClusterState currentState) {
                ProjectMetadata project = currentState.metadata().getProject(projectId);
                ViewMetadata viewMetadata = ViewService.this.getMetadata(project);
                View currentView = viewMetadata.getView(view.name());
                if (view.equals((Object)currentView)) {
                    return currentState;
                }
                ViewService.this.validatePutView(metadata, view);
                HashMap<String, View> updatedViews = new HashMap<String, View>(viewMetadata.views());
                updatedViews.put(view.name(), view);
                ProjectMetadata.Builder metadata2 = ProjectMetadata.builder((ProjectMetadata)project).putCustom("esql_view", (Metadata.ProjectCustom)new ViewMetadata(updatedViews));
                return ClusterState.builder((ClusterState)currentState).putProjectMetadata(metadata2).build();
            }
        };
        this.taskQueue.submitTask("update-esql-view-metadata-[" + view.name() + "]", (ClusterStateTaskListener)task, task.timeout());
    }

    public void deleteView(final ProjectId projectId, DeleteViewAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        if (!this.viewsFeatureEnabled()) {
            listener.onFailure((Exception)new IllegalArgumentException("ESQL views are not enabled"));
            return;
        }
        final String name = request.name();
        ProjectMetadata metadata = this.clusterService.state().metadata().getProject(projectId);
        ViewMetadata viewMetadata = (ViewMetadata)metadata.custom("esql_view", (Metadata.ProjectCustom)ViewMetadata.EMPTY);
        if (viewMetadata.getView(name) == null) {
            listener.onFailure((Exception)new ResourceNotFoundException("view [{}] not found", new Object[]{name}));
            return;
        }
        AckedClusterStateUpdateTask task = new AckedClusterStateUpdateTask(request, listener){

            public ClusterState execute(ClusterState currentState) {
                ProjectMetadata project = currentState.metadata().getProject(projectId);
                ViewMetadata viewMetadata = ViewService.this.getMetadata(project);
                View currentView = viewMetadata.getView(name);
                if (currentView == null) {
                    return currentState;
                }
                HashMap updatedViews = new HashMap(viewMetadata.views());
                View existingView = (View)updatedViews.remove(name);
                assert (existingView != null) : "we should have short-circuited if removing a view that already didn't exist";
                ProjectMetadata.Builder metadata = ProjectMetadata.builder((ProjectMetadata)project).putCustom("esql_view", (Metadata.ProjectCustom)new ViewMetadata(updatedViews));
                return ClusterState.builder((ClusterState)currentState).putProjectMetadata(metadata).build();
            }
        };
        this.taskQueue.submitTask("delete-esql-view-metadata-[" + name + "]", (ClusterStateTaskListener)task, task.timeout());
    }

    void validatePutView(ProjectMetadata metadata, View view) {
        if (view.query().length() > this.maxViewLength) {
            throw new IllegalArgumentException("view query is too large: " + view.query().length() + " characters, the maximum allowed is " + this.maxViewLength);
        }
        ViewMetadata views = this.getMetadata(metadata);
        View existing = views.getView(view.name());
        if (existing == null && views.views().size() >= this.maxViewsCount) {
            throw new IllegalArgumentException("cannot add view, the maximum number of views is reached: " + this.maxViewsCount);
        }
        EsqlParser.INSTANCE.parseQuery(view.query(), new QueryParams(), this.telemetry, EMPTY_INFERENCE_SETTINGS);
    }

    @Nullable
    public View get(ProjectId projectId, String name) {
        if (!Strings.hasText((String)name)) {
            throw new IllegalArgumentException("name is missing or empty");
        }
        return this.viewsFeatureEnabled() ? this.getMetadata(projectId).getView(name) : null;
    }

    public Set<String> list(ProjectId projectId) {
        return this.viewsFeatureEnabled() ? this.getMetadata(projectId).views().keySet() : Set.of();
    }

    protected boolean viewsFeatureEnabled() {
        return EsqlFeatures.ESQL_VIEWS_FEATURE_FLAG.isEnabled();
    }

    public LogicalPlan replaceViews(LogicalPlan plan, Function<String, LogicalPlan> parser) {
        LogicalPlan prev;
        if (!this.viewsFeatureEnabled()) {
            return plan;
        }
        ViewMetadata views = this.getMetadata();
        ArrayList seen = new ArrayList();
        do {
            prev = plan;
        } while (!(plan = plan.transformUp(UnresolvedRelation.class, ur -> {
            ArrayList<String> indexes = new ArrayList<String>();
            ArrayList<LogicalPlan> subqueries = new ArrayList<LogicalPlan>();
            for (String name : ur.indexPattern().indexPattern().split(",")) {
                View view = views.getView(name = name.trim());
                if (view != null) {
                    boolean alreadySeen = seen.contains(name);
                    seen.add(name);
                    if (alreadySeen) {
                        throw this.viewError("circular view reference ", seen);
                    }
                    if (seen.size() > this.maxViewDepth) {
                        throw this.viewError("The maximum allowed view depth of " + this.maxViewDepth + " has been exceeded: ", seen);
                    }
                    subqueries.add(ViewService.resolve(view, parser));
                    continue;
                }
                indexes.add(name);
            }
            if (subqueries.isEmpty()) {
                return ur;
            }
            if (indexes.isEmpty()) {
                if (subqueries.size() == 1) {
                    return (LogicalPlan)subqueries.getFirst();
                }
            } else {
                subqueries.addFirst(new UnresolvedRelation(ur.source(), new IndexPattern(ur.indexPattern().source(), String.join((CharSequence)",", indexes)), ur.frozen(), ur.metadataFields(), ur.indexMode(), ur.unresolvedMessage()));
            }
            return new UnionAll(ur.source(), subqueries, List.of());
        })).equals(prev));
        return prev;
    }

    private static LogicalPlan resolve(View view, Function<String, LogicalPlan> parser) {
        return parser.apply(view.query());
    }

    private VerificationException viewError(String type, List<String> seen) {
        StringBuilder b = new StringBuilder();
        for (String s : seen) {
            if (b.isEmpty()) {
                b.append(type);
            } else {
                b.append(" -> ");
            }
            b.append(s);
        }
        throw new VerificationException(b.toString(), new Object[0]);
    }
}

