/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.view;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeProjectAction;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.esql.view.PutViewAction;
import org.elasticsearch.xpack.esql.view.ViewService;

public class TransportPutViewAction
extends AcknowledgedTransportMasterNodeProjectAction<PutViewAction.Request> {
    private final ViewService viewService;

    @Inject
    public TransportPutViewAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, ViewService viewService, ProjectResolver projectResolver) {
        super("cluster:admin/xpack/esql/view/put", transportService, clusterService, threadPool, actionFilters, PutViewAction.Request::new, projectResolver, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.viewService = viewService;
    }

    protected void masterOperation(Task task, PutViewAction.Request request, ProjectState state, ActionListener<AcknowledgedResponse> listener) {
        this.viewService.putView(state.projectId(), request, listener);
    }

    protected ClusterBlockException checkBlock(PutViewAction.Request request, ProjectState state) {
        return state.blocks().globalBlockedException(state.projectId(), ClusterBlockLevel.METADATA_WRITE);
    }
}

