/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.view;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.remote.RemoteInfoResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.local.TransportLocalProjectMetadataAction;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.View;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.esql.view.GetViewAction;
import org.elasticsearch.xpack.esql.view.ViewService;

public class TransportGetViewAction
extends TransportLocalProjectMetadataAction<GetViewAction.Request, GetViewAction.Response> {
    public static final ActionType<RemoteInfoResponse> TYPE = new ActionType("cluster:admin/xpack/esql/view/get");
    private final ViewService viewService;

    @Inject
    public TransportGetViewAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, ProjectResolver projectResolver, ViewService viewService) {
        super("cluster:admin/xpack/esql/view/get", actionFilters, transportService.getTaskManager(), clusterService, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE, projectResolver);
        this.viewService = viewService;
    }

    protected void localClusterStateOperation(Task task, GetViewAction.Request request, ProjectState project, ActionListener<GetViewAction.Response> listener) {
        ProjectId projectId = project.projectId();
        ArrayList<View> views = new ArrayList();
        ArrayList<String> missing = new ArrayList<String>();
        List<String> names = request.names();
        if (names.isEmpty()) {
            views = this.viewService.getMetadata(projectId).views().values();
        } else {
            for (String name : names) {
                View view = this.viewService.get(projectId, name);
                if (view == null) {
                    missing.add(name);
                    continue;
                }
                views.add(view);
            }
        }
        if (!missing.isEmpty()) {
            listener.onFailure((Exception)new ResourceNotFoundException("Views do not exist: " + String.join((CharSequence)", ", missing), new Object[0]));
        } else {
            listener.onResponse((Object)new GetViewAction.Response(views));
        }
    }

    protected ClusterBlockException checkBlock(GetViewAction.Request request, ProjectState state) {
        return state.blocks().globalBlockedException(state.projectId(), ClusterBlockLevel.METADATA_READ);
    }
}

