/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.view;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeProjectAction;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.esql.view.DeleteViewAction;
import org.elasticsearch.xpack.esql.view.ViewService;

public class TransportDeleteViewAction
extends AcknowledgedTransportMasterNodeProjectAction<DeleteViewAction.Request> {
    private final ViewService viewService;

    @Inject
    public TransportDeleteViewAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, ProjectResolver projectResolver, ViewService viewService) {
        super("cluster:admin/xpack/esql/view/delete", transportService, clusterService, threadPool, actionFilters, DeleteViewAction.Request::new, projectResolver, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.viewService = viewService;
    }

    protected void masterOperation(Task task, DeleteViewAction.Request request, ProjectState state, ActionListener<AcknowledgedResponse> listener) {
        this.viewService.deleteView(state.projectId(), request, listener);
    }

    protected ClusterBlockException checkBlock(DeleteViewAction.Request request, ProjectState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

