/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.view;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.View;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;

public class PutViewAction
extends ActionType<AcknowledgedResponse> {
    public static final PutViewAction INSTANCE = new PutViewAction();
    public static final String NAME = "cluster:admin/xpack/esql/view/put";

    private PutViewAction() {
        super(NAME);
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final View view;

        public Request(TimeValue masterNodeTimeout, TimeValue ackTimeout, View view) {
            super(masterNodeTimeout, ackTimeout);
            this.view = view;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.view = new View(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.view.writeTo(out);
        }

        public ActionRequestValidationException validate() {
            String query;
            ActionRequestValidationException validationException = null;
            if (this.view == null) {
                validationException = ValidateActions.addValidationError((String)"view is missing", validationException);
                return validationException;
            }
            String name = this.view.name();
            try {
                MetadataCreateIndexService.validateIndexOrAliasName((String)name, (viewName, error) -> new IllegalArgumentException("invalid view name [" + name + "], " + error));
            }
            catch (IllegalArgumentException e) {
                validationException = ValidateActions.addValidationError((String)e.getMessage(), (ActionRequestValidationException)validationException);
            }
            if (!name.toLowerCase(Locale.ROOT).equals(name)) {
                validationException = ValidateActions.addValidationError((String)("invalid view name [" + name + "], must be lowercase"), (ActionRequestValidationException)validationException);
            }
            if (!Strings.hasText((String)(query = this.view.query()))) {
                validationException = ValidateActions.addValidationError((String)"view query is missing or empty", (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        public View view() {
            return this.view;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return this.view.equals((Object)request.view);
        }

        public int hashCode() {
            return Objects.hash(this.view);
        }
    }
}

