/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.view;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;

public class DeleteViewAction
extends ActionType<AcknowledgedResponse> {
    public static final DeleteViewAction INSTANCE = new DeleteViewAction();
    public static final String NAME = "cluster:admin/xpack/esql/view/delete";

    private DeleteViewAction() {
        super(NAME);
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final String name;

        public Request(TimeValue masterNodeTimeout, TimeValue ackTimeout, String name) {
            super(masterNodeTimeout, ackTimeout);
            this.name = Objects.requireNonNull(name, "name cannot be null");
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.name = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.name);
        }

        public String name() {
            return this.name;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (!Strings.hasText((String)this.name)) {
                validationException = ValidateActions.addValidationError((String)"name cannot be null or missing", validationException);
            }
            return validationException;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return this.name.equals(request.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }
    }
}

