/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.telemetry;

import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.watcher.common.stats.Counters;

public class TookMetrics {
    public static final long ONE_SECOND = TimeValue.timeValueSeconds((long)1L).millis();
    public static final long TEN_SECONDS = TimeValue.timeValueSeconds((long)10L).millis();
    public static final long ONE_MINUTE = TimeValue.timeValueMinutes((long)1L).millis();
    public static final long TEN_MINUTES = TimeValue.timeValueMinutes((long)10L).millis();
    public static final long ONE_HOUR = TimeValue.timeValueHours((long)1L).millis();
    public static final long TEN_HOURS = TimeValue.timeValueHours((long)10L).millis();
    public static final long ONE_DAY = TimeValue.timeValueDays((long)1L).millis();
    private final CounterMetric lessThan10ms = new CounterMetric();
    private final CounterMetric lessThan100ms = new CounterMetric();
    private final CounterMetric lessThan1s = new CounterMetric();
    private final CounterMetric lessThan10s = new CounterMetric();
    private final CounterMetric lessThan1m = new CounterMetric();
    private final CounterMetric lessThan10m = new CounterMetric();
    private final CounterMetric lessThan1h = new CounterMetric();
    private final CounterMetric lessThan10h = new CounterMetric();
    private final CounterMetric lessThan1d = new CounterMetric();
    private final CounterMetric greaterThan1d = new CounterMetric();

    public void count(long tookMillis) {
        if (tookMillis < 10L) {
            this.lessThan10ms.inc();
            return;
        }
        if (tookMillis < 100L) {
            this.lessThan100ms.inc();
            return;
        }
        if (tookMillis < ONE_SECOND) {
            this.lessThan1s.inc();
            return;
        }
        if (tookMillis < TEN_SECONDS) {
            this.lessThan10s.inc();
            return;
        }
        if (tookMillis < ONE_MINUTE) {
            this.lessThan1m.inc();
            return;
        }
        if (tookMillis < TEN_MINUTES) {
            this.lessThan10m.inc();
            return;
        }
        if (tookMillis < ONE_HOUR) {
            this.lessThan1h.inc();
            return;
        }
        if (tookMillis < TEN_HOURS) {
            this.lessThan10h.inc();
            return;
        }
        if (tookMillis < ONE_DAY) {
            this.lessThan1d.inc();
            return;
        }
        this.greaterThan1d.inc();
    }

    public void counters(String prefix, Counters counters) {
        counters.inc(prefix + "lt_10ms", this.lessThan10ms.count());
        counters.inc(prefix + "lt_100ms", this.lessThan100ms.count());
        counters.inc(prefix + "lt_1s", this.lessThan1s.count());
        counters.inc(prefix + "lt_10s", this.lessThan10s.count());
        counters.inc(prefix + "lt_1m", this.lessThan1m.count());
        counters.inc(prefix + "lt_10m", this.lessThan10m.count());
        counters.inc(prefix + "lt_1h", this.lessThan1h.count());
        counters.inc(prefix + "lt_10h", this.lessThan10h.count());
        counters.inc(prefix + "lt_1d", this.lessThan1d.count());
        counters.inc(prefix + "gt_1d", this.greaterThan1d.count());
    }
}

