/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.telemetry;

import java.util.BitSet;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.ChangePoint;
import org.elasticsearch.xpack.esql.plan.logical.Dissect;
import org.elasticsearch.xpack.esql.plan.logical.Drop;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Explain;
import org.elasticsearch.xpack.esql.plan.logical.Filter;
import org.elasticsearch.xpack.esql.plan.logical.Fork;
import org.elasticsearch.xpack.esql.plan.logical.Grok;
import org.elasticsearch.xpack.esql.plan.logical.InlineStats;
import org.elasticsearch.xpack.esql.plan.logical.Insist;
import org.elasticsearch.xpack.esql.plan.logical.Keep;
import org.elasticsearch.xpack.esql.plan.logical.Limit;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Lookup;
import org.elasticsearch.xpack.esql.plan.logical.MvExpand;
import org.elasticsearch.xpack.esql.plan.logical.OrderBy;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.Rename;
import org.elasticsearch.xpack.esql.plan.logical.Row;
import org.elasticsearch.xpack.esql.plan.logical.Sample;
import org.elasticsearch.xpack.esql.plan.logical.Subquery;
import org.elasticsearch.xpack.esql.plan.logical.UnresolvedRelation;
import org.elasticsearch.xpack.esql.plan.logical.fuse.Fuse;
import org.elasticsearch.xpack.esql.plan.logical.fuse.FuseScoreEval;
import org.elasticsearch.xpack.esql.plan.logical.inference.Completion;
import org.elasticsearch.xpack.esql.plan.logical.inference.Rerank;
import org.elasticsearch.xpack.esql.plan.logical.join.LookupJoin;
import org.elasticsearch.xpack.esql.plan.logical.local.EsqlProject;
import org.elasticsearch.xpack.esql.plan.logical.promql.PromqlCommand;
import org.elasticsearch.xpack.esql.plan.logical.show.ShowInfo;

public enum FeatureMetric {
    DISSECT(Dissect.class::isInstance),
    EVAL(Eval.class::isInstance),
    GROK(Grok.class::isInstance),
    LIMIT(plan -> false),
    SORT(OrderBy.class::isInstance),
    STATS(plan -> false),
    WHERE(Filter.class::isInstance),
    ENRICH(Enrich.class::isInstance),
    EXPLAIN(Explain.class::isInstance),
    MV_EXPAND(MvExpand.class::isInstance),
    SHOW(ShowInfo.class::isInstance),
    ROW(Row.class::isInstance),
    FROM(x -> {
        EsRelation relation;
        return x instanceof EsRelation && (relation = (EsRelation)x).indexMode() != IndexMode.TIME_SERIES;
    }),
    TS(x -> {
        EsRelation relation;
        return x instanceof EsRelation && (relation = (EsRelation)x).indexMode() == IndexMode.TIME_SERIES;
    }),
    DROP(Drop.class::isInstance),
    KEEP(Keep.class::isInstance),
    RENAME(Rename.class::isInstance),
    LOOKUP_JOIN(plan -> {
        LookupJoin lookupJoin;
        return plan instanceof LookupJoin && (lookupJoin = (LookupJoin)plan).config().joinOnConditions() == null;
    }),
    LOOKUP_JOIN_ON_EXPRESSION(plan -> {
        LookupJoin lookupJoin;
        return plan instanceof LookupJoin && (lookupJoin = (LookupJoin)plan).config().joinOnConditions() != null;
    }),
    LOOKUP(Lookup.class::isInstance),
    CHANGE_POINT(ChangePoint.class::isInstance),
    INLINE_STATS(InlineStats.class::isInstance),
    RERANK(Rerank.class::isInstance),
    INSIST(Insist.class::isInstance),
    FORK(Fork.class::isInstance),
    FUSE(Fuse.class::isInstance),
    COMPLETION(Completion.class::isInstance),
    SAMPLE(Sample.class::isInstance),
    SUBQUERY(Subquery.class::isInstance),
    PROMQL(PromqlCommand.class::isInstance);

    private static final List<Class<? extends LogicalPlan>> excluded;
    private Predicate<LogicalPlan> planCheck;

    private FeatureMetric(Predicate<LogicalPlan> planCheck) {
        this.planCheck = planCheck;
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static void set(LogicalPlan plan, BitSet bitset) {
        for (FeatureMetric metric : FeatureMetric.values()) {
            if (!FeatureMetric.set(plan, bitset, metric)) continue;
            return;
        }
        if (!FeatureMetric.explicitlyExcluded(plan)) {
            throw new EsqlIllegalArgumentException("Command not mapped for telemetry [{}]", plan.getClass().getSimpleName());
        }
    }

    private static boolean explicitlyExcluded(LogicalPlan plan) {
        return excluded.stream().anyMatch(x -> x.isInstance(plan));
    }

    public static boolean set(LogicalPlan plan, BitSet bitset, FeatureMetric metric) {
        boolean isMatch = metric.planCheck.test(plan);
        if (isMatch) {
            bitset.set(metric.ordinal());
        }
        return isMatch;
    }

    static {
        excluded = List.of(UnresolvedRelation.class, EsqlProject.class, Project.class, Limit.class, FuseScoreEval.class, Aggregate.class);
    }
}

