/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.querydsl.query;

import org.apache.lucene.search.Query;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.TextFieldMapper;
import org.elasticsearch.index.query.BaseTermQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xpack.esql.core.tree.Source;

public class EqualsSyntheticSourceDelegate
extends org.elasticsearch.xpack.esql.core.querydsl.query.Query {
    private final String fieldName;
    private final String value;

    public EqualsSyntheticSourceDelegate(Source source, String fieldName, String value) {
        super(source);
        this.fieldName = fieldName;
        this.value = value;
    }

    @Override
    protected QueryBuilder asBuilder() {
        return new Builder(this, this.fieldName, this.value);
    }

    @Override
    protected String innerToString() {
        return this.fieldName + "(delegate):" + this.value;
    }

    @Override
    public boolean containsPlan() {
        return false;
    }

    private class Builder
    extends BaseTermQueryBuilder<Builder> {
        private Builder(EqualsSyntheticSourceDelegate equalsSyntheticSourceDelegate, String name, String value) {
            super(name, value);
        }

        protected Query doToQuery(SearchExecutionContext context) {
            TextFieldMapper.TextFieldType ft = (TextFieldMapper.TextFieldType)context.getFieldType(this.fieldName);
            return ((KeywordFieldMapper.KeywordFieldType)ft.syntheticSourceDelegate().orElse(null)).termQuery(this.value, context);
        }

        public String getWriteableName() {
            return "equals_synthetic_source_delegate";
        }

        public TransportVersion getMinimalSupportedVersion() {
            throw new UnsupportedOperationException();
        }
    }
}

