/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.util.TreeSet;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.node.tasks.get.GetTaskRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.get.GetTaskResponse;
import org.elasticsearch.action.admin.cluster.node.tasks.get.TransportGetTaskAction;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.elasticsearch.action.admin.cluster.node.tasks.list.TransportListTasksAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.compute.operator.DriverStatus;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskInfo;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.esql.action.EsqlGetQueryRequest;
import org.elasticsearch.xpack.esql.plugin.EsqlGetQueryResponse;

public class TransportEsqlGetQueryAction
extends HandledTransportAction<EsqlGetQueryRequest, EsqlGetQueryResponse> {
    private final NodeClient nodeClient;

    @Inject
    public TransportEsqlGetQueryAction(TransportService transportService, NodeClient nodeClient, ActionFilters actionFilters) {
        super("cluster:monitor/xpack/esql/get_query", transportService, actionFilters, EsqlGetQueryRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.nodeClient = nodeClient;
    }

    protected void doExecute(Task task, final EsqlGetQueryRequest request, final ActionListener<EsqlGetQueryResponse> listener) {
        ClientHelper.executeAsyncWithOrigin((Client)this.nodeClient, (String)"esql", (ActionType)TransportGetTaskAction.TYPE, (ActionRequest)new GetTaskRequest().setTaskId(request.id().getTaskId()), (ActionListener)new ActionListener<GetTaskResponse>(){

            public void onResponse(GetTaskResponse response) {
                final TaskInfo task = response.getTask().getTask();
                if (!task.action().startsWith("indices:data/read/esql")) {
                    listener.onFailure((Exception)new IllegalArgumentException("Task [" + String.valueOf(request.id()) + "] is not an ESQL query task"));
                    return;
                }
                ClientHelper.executeAsyncWithOrigin((Client)TransportEsqlGetQueryAction.this.nodeClient, (String)"esql", (ActionType)TransportListTasksAction.TYPE, (ActionRequest)((ListTasksRequest)((ListTasksRequest)new ListTasksRequest().setDetailed(true).setActions(new String[]{"indices:data/read/esql/compute"})).setTargetParentTaskId(request.id().getTaskId())), (ActionListener)new ActionListener<ListTasksResponse>(){

                    public void onResponse(ListTasksResponse response) {
                        listener.onResponse((Object)new EsqlGetQueryResponse(TransportEsqlGetQueryAction.toDetailedQuery(task, response)));
                    }

                    public void onFailure(Exception e) {
                        listener.onFailure(e);
                    }
                });
            }

            public void onFailure(Exception e) {
                Exception withoutCause = new Exception(e.getMessage());
                listener.onFailure(withoutCause);
            }
        });
    }

    private static EsqlGetQueryResponse.DetailedQuery toDetailedQuery(TaskInfo main, ListTasksResponse sub) {
        String query = main.description();
        long documentsFound = 0L;
        long valuesLoaded = 0L;
        TreeSet<String> dataNodes = new TreeSet<String>();
        for (TaskInfo info : sub.getTasks()) {
            DriverStatus status = (DriverStatus)info.status();
            documentsFound += status.documentsFound();
            valuesLoaded += status.valuesLoaded();
            dataNodes.add(info.node());
        }
        return new EsqlGetQueryResponse.DetailedQuery(main.taskId(), main.startTime(), main.runningTimeNanos(), documentsFound, valuesLoaded, query);
    }
}

