/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.cluster.RemoteException;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.RunOnce;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.lucene.EmptyIndexedByShardId;
import org.elasticsearch.compute.lucene.IndexedByShardId;
import org.elasticsearch.compute.operator.Driver;
import org.elasticsearch.compute.operator.DriverCompletionInfo;
import org.elasticsearch.compute.operator.DriverTaskRunner;
import org.elasticsearch.compute.operator.FailureCollector;
import org.elasticsearch.compute.operator.PlanTimeProfile;
import org.elasticsearch.compute.operator.exchange.ExchangeService;
import org.elasticsearch.compute.operator.exchange.ExchangeSink;
import org.elasticsearch.compute.operator.exchange.ExchangeSinkHandler;
import org.elasticsearch.compute.operator.exchange.ExchangeSourceHandler;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskAwareRequest;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.AbstractTransportRequest;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.esql.action.EsqlExecutionInfo;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.enrich.EnrichLookupService;
import org.elasticsearch.xpack.esql.enrich.LookupFromIndexService;
import org.elasticsearch.xpack.esql.inference.InferenceService;
import org.elasticsearch.xpack.esql.optimizer.LocalPhysicalOptimizerContext;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeSinkExec;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.OutputExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.planner.EsPhysicalOperationProviders;
import org.elasticsearch.xpack.esql.planner.LocalExecutionPlanner;
import org.elasticsearch.xpack.esql.planner.PlannerSettings;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;
import org.elasticsearch.xpack.esql.plugin.ClusterComputeHandler;
import org.elasticsearch.xpack.esql.plugin.ComputeContext;
import org.elasticsearch.xpack.esql.plugin.ComputeListener;
import org.elasticsearch.xpack.esql.plugin.ComputeResponse;
import org.elasticsearch.xpack.esql.plugin.ComputeSearchContext;
import org.elasticsearch.xpack.esql.plugin.DataNodeComputeHandler;
import org.elasticsearch.xpack.esql.plugin.EsqlFlags;
import org.elasticsearch.xpack.esql.plugin.LateMaterializationPlanner;
import org.elasticsearch.xpack.esql.plugin.QueryPragmas;
import org.elasticsearch.xpack.esql.plugin.ReductionPlan;
import org.elasticsearch.xpack.esql.plugin.TransportActionServices;
import org.elasticsearch.xpack.esql.session.Configuration;
import org.elasticsearch.xpack.esql.session.EsqlCCSUtils;
import org.elasticsearch.xpack.esql.session.Result;
import org.elasticsearch.xpack.esql.stats.SearchStats;

public class ComputeService {
    public static final String DATA_DESCRIPTION = "data";
    public static final String REDUCE_DESCRIPTION = "node_reduce";
    public static final String DATA_ACTION_NAME = "indices:data/read/esql/data";
    public static final String CLUSTER_ACTION_NAME = "indices:data/read/esql/cluster";
    private static final String LOCAL_CLUSTER = "";
    private static final Logger LOGGER = LogManager.getLogger(ComputeService.class);
    private final SearchService searchService;
    private final BigArrays bigArrays;
    private final BlockFactory blockFactory;
    private final TransportService transportService;
    private final DriverTaskRunner driverRunner;
    private final EnrichLookupService enrichLookupService;
    private final LookupFromIndexService lookupFromIndexService;
    private final InferenceService inferenceService;
    private final ClusterService clusterService;
    private final ProjectResolver projectResolver;
    private final AtomicLong childSessionIdGenerator = new AtomicLong();
    private final DataNodeComputeHandler dataNodeComputeHandler;
    private final ClusterComputeHandler clusterComputeHandler;
    private final ExchangeService exchangeService;
    private final PlannerSettings plannerSettings;

    public ComputeService(TransportActionServices transportActionServices, EnrichLookupService enrichLookupService, LookupFromIndexService lookupFromIndexService, ThreadPool threadPool, BigArrays bigArrays, BlockFactory blockFactory) {
        this.searchService = transportActionServices.searchService();
        this.transportService = transportActionServices.transportService();
        this.exchangeService = transportActionServices.exchangeService();
        this.bigArrays = bigArrays.withCircuitBreaking();
        this.blockFactory = blockFactory;
        ExecutorService esqlExecutor = threadPool.executor("search");
        this.driverRunner = new DriverTaskRunner(this.transportService, (Executor)esqlExecutor);
        this.enrichLookupService = enrichLookupService;
        this.lookupFromIndexService = lookupFromIndexService;
        this.inferenceService = transportActionServices.inferenceService();
        this.clusterService = transportActionServices.clusterService();
        this.projectResolver = transportActionServices.projectResolver();
        this.dataNodeComputeHandler = new DataNodeComputeHandler(this, this.clusterService, this.projectResolver, this.searchService, this.transportService, this.exchangeService, esqlExecutor);
        this.clusterComputeHandler = new ClusterComputeHandler(this, this.exchangeService, this.transportService, esqlExecutor, this.dataNodeComputeHandler);
        this.plannerSettings = transportActionServices.plannerSettings();
    }

    PlannerSettings plannerSettings() {
        return this.plannerSettings;
    }

    public void execute(String sessionId, CancellableTask rootTask, EsqlFlags flags, PhysicalPlan physicalPlan, Configuration configuration, FoldContext foldContext, EsqlExecutionInfo execInfo, PlanTimeProfile planTimeProfile, ActionListener<Result> listener) {
        assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"esql_worker", "system_read", "search", "search_coordination"}));
        Tuple<List<PhysicalPlan>, PhysicalPlan> subplansAndMainPlan = PlannerUtils.breakPlanIntoSubPlansAndMainPlan(physicalPlan);
        List subplans = (List)subplansAndMainPlan.v1();
        HashMap<String, EsqlExecutionInfo.Cluster.Status> initialClusterStatuses = new HashMap<String, EsqlExecutionInfo.Cluster.Status>(execInfo.clusterInfo.size());
        for (Map.Entry entry : execInfo.clusterInfo.entrySet()) {
            initialClusterStatuses.put((String)entry.getKey(), ((EsqlExecutionInfo.Cluster)entry.getValue()).getStatus());
        }
        if (subplans == null || subplans.isEmpty()) {
            this.executePlan(sessionId, rootTask, flags, physicalPlan, configuration, foldContext, execInfo, null, listener, null, initialClusterStatuses, planTimeProfile);
            return;
        }
        List collectedPages = Collections.synchronizedList(new ArrayList());
        OutputExec mainPlan = new OutputExec((PhysicalPlan)subplansAndMainPlan.v2(), collectedPages::add);
        listener = listener.delegateResponse((l, e) -> {
            collectedPages.forEach(p -> Releasables.closeExpectNoException(() -> ((Page)p).releaseBlocks()));
            l.onFailure(e);
        });
        String mainSessionId = this.newChildSession(sessionId);
        QueryPragmas queryPragmas = configuration.pragmas();
        ExchangeSourceHandler mainExchangeSource = new ExchangeSourceHandler(queryPragmas.exchangeBufferSize(), (Executor)this.transportService.getThreadPool().executor("search"));
        this.exchangeService.addExchangeSourceHandler(mainSessionId, mainExchangeSource);
        try (Releasable ignored = mainExchangeSource.addEmptySink();){
            ActionListener finalListener = ActionListener.runBefore((ActionListener)listener, () -> this.exchangeService.removeExchangeSourceHandler(sessionId));
            ComputeContext computeContext = new ComputeContext(mainSessionId, "main.final", LOCAL_CLUSTER, flags, (IndexedByShardId<ComputeSearchContext>)EmptyIndexedByShardId.instance(), configuration, foldContext, () -> ((ExchangeSourceHandler)mainExchangeSource).createExchangeSource(), null);
            Runnable cancelQueryOnFailure = this.cancelQueryOnFailure(rootTask);
            try (ComputeListener localListener = new ComputeListener(this.transportService.getThreadPool(), cancelQueryOnFailure, (ActionListener<DriverCompletionInfo>)finalListener.map(profiles -> {
                execInfo.markEndQuery();
                return new Result(mainPlan.output(), collectedPages, (DriverCompletionInfo)profiles, execInfo);
            }));){
                this.runCompute(rootTask, computeContext, mainPlan, planTimeProfile, localListener.acquireCompute());
                for (int i = 0; i < subplans.size(); ++i) {
                    PhysicalPlan subplan = (PhysicalPlan)subplans.get(i);
                    String childSessionId = this.newChildSession(sessionId);
                    ExchangeSinkHandler exchangeSink = this.exchangeService.createSinkHandler(childSessionId, queryPragmas.exchangeBufferSize());
                    mainExchangeSource.addRemoteSink((arg_0, arg_1) -> ((ExchangeSinkHandler)exchangeSink).fetchPageAsync(arg_0, arg_1), true, () -> {}, 1, ActionListener.noop());
                    ActionListener<DriverCompletionInfo> subPlanListener = localListener.acquireCompute();
                    this.executePlan(childSessionId, rootTask, flags, subplan, configuration, foldContext, execInfo, "subplan-" + i, (ActionListener<Result>)ActionListener.wrap(result -> {
                        exchangeSink.addCompletionListener(ActionListener.running(() -> this.exchangeService.finishSinkHandler(childSessionId, null)));
                        subPlanListener.onResponse((Object)result.completionInfo());
                    }, e -> {
                        this.exchangeService.finishSinkHandler(childSessionId, e);
                        subPlanListener.onFailure(e);
                    }), () -> exchangeSink.createExchangeSink(() -> {}), initialClusterStatuses, configuration.profile() ? new PlanTimeProfile() : null);
                }
            }
        }
    }

    public void executePlan(String sessionId, CancellableTask rootTask, EsqlFlags flags, PhysicalPlan physicalPlan, Configuration configuration, FoldContext foldContext, EsqlExecutionInfo execInfo, String profileQualifier, ActionListener<Result> listener, Supplier<ExchangeSink> exchangeSinkSupplier, Map<String, EsqlExecutionInfo.Cluster.Status> initialClusterStatuses, PlanTimeProfile planTimeProfile) {
        PhysicalPlan dataNodePlan;
        Tuple<PhysicalPlan, PhysicalPlan> coordinatorAndDataNodePlan = PlannerUtils.breakPlanBetweenCoordinatorAndDataNode(physicalPlan, configuration);
        List collectedPages = Collections.synchronizedList(new ArrayList());
        listener = listener.delegateResponse((l, e) -> {
            collectedPages.forEach(p -> Releasables.closeExpectNoException(() -> ((Page)p).releaseBlocks()));
            l.onFailure(e);
        });
        PhysicalPlan coordinatorPlan = (PhysicalPlan)coordinatorAndDataNodePlan.v1();
        if (exchangeSinkSupplier == null) {
            coordinatorPlan = new OutputExec((PhysicalPlan)coordinatorAndDataNodePlan.v1(), collectedPages::add);
        }
        if ((dataNodePlan = (PhysicalPlan)coordinatorAndDataNodePlan.v2()) != null && !(dataNodePlan instanceof ExchangeSinkExec)) {
            assert (false) : "expected data node plan starts with an ExchangeSink; got " + String.valueOf(dataNodePlan);
            listener.onFailure((Exception)new IllegalStateException("expected data node plan starts with an ExchangeSink; got " + String.valueOf(dataNodePlan)));
            return;
        }
        Map<String, OriginalIndices> clusterToConcreteIndices = ComputeService.getIndices(physicalPlan, EsRelation::concreteIndices);
        Runnable cancelQueryOnFailure = this.cancelQueryOnFailure(rootTask);
        if (dataNodePlan == null) {
            if (!clusterToConcreteIndices.values().stream().allMatch(v -> v.indices().length == 0)) {
                String error = "expected no concrete indices without data node plan; got " + String.valueOf(clusterToConcreteIndices);
                assert (false) : error;
                listener.onFailure((Exception)new IllegalStateException(error));
                return;
            }
            ComputeContext computeContext = new ComputeContext(this.newChildSession(sessionId), this.profileDescription(profileQualifier, "single"), LOCAL_CLUSTER, flags, (IndexedByShardId<ComputeSearchContext>)EmptyIndexedByShardId.instance(), configuration, foldContext, null, exchangeSinkSupplier);
            ComputeService.updateShardCountForCoordinatorOnlyQuery(execInfo);
            try (ComputeListener computeListener = new ComputeListener(this.transportService.getThreadPool(), cancelQueryOnFailure, (ActionListener<DriverCompletionInfo>)listener.map(completionInfo -> {
                ComputeService.updateExecutionInfoAfterCoordinatorOnlyQuery(execInfo);
                return new Result(physicalPlan.output(), collectedPages, (DriverCompletionInfo)completionInfo, execInfo);
            }));){
                this.runCompute(rootTask, computeContext, coordinatorPlan, planTimeProfile, computeListener.acquireCompute());
                return;
            }
        }
        if (clusterToConcreteIndices.values().stream().allMatch(v -> v.indices().length == 0)) {
            String error = "expected concrete indices with data node plan but got empty; data node plan " + String.valueOf(dataNodePlan);
            assert (false) : error;
            listener.onFailure((Exception)new IllegalStateException(error));
            return;
        }
        Map<String, OriginalIndices> clusterToOriginalIndices = ComputeService.getIndices(physicalPlan, EsRelation::originalIndices);
        OriginalIndices localOriginalIndices = clusterToOriginalIndices.remove(LOCAL_CLUSTER);
        OriginalIndices localConcreteIndices = clusterToConcreteIndices.remove(LOCAL_CLUSTER);
        List<Attribute> outputAttributes = physicalPlan.output();
        ExchangeSourceHandler exchangeSource = new ExchangeSourceHandler(configuration.pragmas().exchangeBufferSize(), (Executor)this.transportService.getThreadPool().executor("search"));
        listener = ActionListener.runBefore((ActionListener)listener, () -> this.exchangeService.removeExchangeSourceHandler(sessionId));
        this.exchangeService.addExchangeSourceHandler(sessionId, exchangeSource);
        try (ComputeListener computeListener = new ComputeListener(this.transportService.getThreadPool(), cancelQueryOnFailure, (ActionListener<DriverCompletionInfo>)listener.delegateFailureAndWrap((l, completionInfo) -> {
            ComputeService.failIfAllShardsFailed(execInfo, collectedPages);
            execInfo.markEndQuery();
            l.onResponse((Object)new Result(outputAttributes, collectedPages, (DriverCompletionInfo)completionInfo, execInfo));
        }));
             Releasable ignored = exchangeSource.addEmptySink();){
            AtomicBoolean localClusterWasInterrupted = new AtomicBoolean();
            try (ComputeListener localListener = new ComputeListener(this.transportService.getThreadPool(), cancelQueryOnFailure, (ActionListener<DriverCompletionInfo>)computeListener.acquireCompute().delegateFailure((l, completionInfo) -> {
                if (execInfo.clusterInfo.containsKey(LOCAL_CLUSTER)) {
                    execInfo.swapCluster(LOCAL_CLUSTER, (k, v) -> {
                        TimeValue tookTime = execInfo.tookSoFar();
                        EsqlExecutionInfo.Cluster.Builder builder = new EsqlExecutionInfo.Cluster.Builder((EsqlExecutionInfo.Cluster)v).setTook(tookTime);
                        if (execInfo.isMainPlan() && v.getStatus() == EsqlExecutionInfo.Cluster.Status.RUNNING) {
                            Integer failedShards = execInfo.getCluster(LOCAL_CLUSTER).getFailedShards();
                            EsqlExecutionInfo.Cluster.Status status = localClusterWasInterrupted.get() || failedShards != null && failedShards > 0 || !v.getFailures().isEmpty() ? EsqlExecutionInfo.Cluster.Status.PARTIAL : EsqlExecutionInfo.Cluster.Status.SUCCESSFUL;
                            builder.setStatus(status);
                        }
                        return builder.build();
                    });
                }
                l.onResponse(completionInfo);
            }));){
                this.runCompute(rootTask, new ComputeContext(sessionId, this.profileDescription(profileQualifier, "final"), LOCAL_CLUSTER, flags, (IndexedByShardId<ComputeSearchContext>)EmptyIndexedByShardId.instance(), configuration, foldContext, () -> ((ExchangeSourceHandler)exchangeSource).createExchangeSource(), exchangeSinkSupplier), coordinatorPlan, planTimeProfile, localListener.acquireCompute());
                if (localConcreteIndices != null && localConcreteIndices.indices().length > 0) {
                    ActionListener<DriverCompletionInfo> dataNodesListener = localListener.acquireCompute();
                    this.dataNodeComputeHandler.startComputeOnDataNodes(sessionId, LOCAL_CLUSTER, rootTask, flags, configuration, dataNodePlan, Set.of(localConcreteIndices.indices()), localOriginalIndices, exchangeSource, cancelQueryOnFailure, (ActionListener<ComputeResponse>)ActionListener.wrap(r -> {
                        localClusterWasInterrupted.set(execInfo.isStopped());
                        execInfo.swapCluster(LOCAL_CLUSTER, (k, v) -> new EsqlExecutionInfo.Cluster.Builder((EsqlExecutionInfo.Cluster)v).setTotalShards(r.getTotalShards()).setSuccessfulShards(r.getSuccessfulShards()).setSkippedShards(r.getSkippedShards()).setFailedShards(r.getFailedShards()).addFailures(r.failures).build());
                        dataNodesListener.onResponse((Object)r.getCompletionInfo());
                    }, e -> {
                        if (configuration.allowPartialResults() && EsqlCCSUtils.canAllowPartial(e)) {
                            execInfo.swapCluster(LOCAL_CLUSTER, (k, v) -> new EsqlExecutionInfo.Cluster.Builder((EsqlExecutionInfo.Cluster)v).setStatus(EsqlExecutionInfo.Cluster.Status.PARTIAL).addFailures(List.of(new ShardSearchFailure(e))).build());
                            dataNodesListener.onResponse((Object)DriverCompletionInfo.EMPTY);
                        } else {
                            dataNodesListener.onFailure(e);
                        }
                    }));
                }
            }
            List<ClusterComputeHandler.RemoteCluster> remoteClusters = this.clusterComputeHandler.getRemoteClusters(clusterToConcreteIndices, clusterToOriginalIndices);
            for (ClusterComputeHandler.RemoteCluster cluster : remoteClusters) {
                EsqlExecutionInfo.Cluster.Status clusterStatus;
                String clusterAlias = cluster.clusterAlias();
                EsqlExecutionInfo.Cluster.Status status = clusterStatus = exchangeSinkSupplier != null ? initialClusterStatuses.get(clusterAlias) : execInfo.getCluster(clusterAlias).getStatus();
                if (clusterStatus != EsqlExecutionInfo.Cluster.Status.RUNNING) {
                    LOGGER.trace("skipping execution on remote cluster [{}] since its initial status is [{}]", new Object[]{clusterAlias, clusterStatus});
                    continue;
                }
                this.clusterComputeHandler.startComputeOnRemoteCluster(sessionId, rootTask, configuration, dataNodePlan, exchangeSource, cluster, cancelQueryOnFailure, execInfo, (ActionListener<DriverCompletionInfo>)computeListener.acquireCompute().delegateResponse((l, ex) -> {
                    if (ex instanceof TransportException) {
                        TransportException te = (TransportException)ex;
                        l.onFailure((Exception)new RemoteException(cluster.clusterAlias(), (Throwable)FailureCollector.unwrapTransportException((TransportException)te)));
                    } else {
                        l.onFailure((Exception)new RemoteException(cluster.clusterAlias(), (Throwable)ex));
                    }
                }));
            }
        }
    }

    private static void updateShardCountForCoordinatorOnlyQuery(EsqlExecutionInfo execInfo) {
        if (execInfo.isCrossClusterSearch() || execInfo.includeExecutionMetadata() == EsqlExecutionInfo.IncludeExecutionMetadata.ALWAYS) {
            for (String clusterAlias : execInfo.clusterAliases()) {
                execInfo.swapCluster(clusterAlias, (k, v) -> new EsqlExecutionInfo.Cluster.Builder((EsqlExecutionInfo.Cluster)v).setTotalShards(0).setSuccessfulShards(0).setSkippedShards(0).setFailedShards(0).build());
            }
        }
    }

    private static void updateExecutionInfoAfterCoordinatorOnlyQuery(EsqlExecutionInfo execInfo) {
        execInfo.markEndQuery();
        if ((execInfo.isCrossClusterSearch() || execInfo.includeExecutionMetadata() == EsqlExecutionInfo.IncludeExecutionMetadata.ALWAYS) && execInfo.isMainPlan()) {
            assert (execInfo.planningTookTime() != null) : "Planning took time should be set on EsqlExecutionInfo but is null";
            for (String clusterAlias : execInfo.clusterAliases()) {
                execInfo.swapCluster(clusterAlias, (k, v) -> {
                    EsqlExecutionInfo.Cluster.Builder builder = new EsqlExecutionInfo.Cluster.Builder((EsqlExecutionInfo.Cluster)v).setTook(execInfo.overallTook());
                    if (v.getStatus() == EsqlExecutionInfo.Cluster.Status.RUNNING) {
                        builder.setStatus(EsqlExecutionInfo.Cluster.Status.SUCCESSFUL);
                    }
                    return builder.build();
                });
            }
        }
    }

    static void failIfAllShardsFailed(EsqlExecutionInfo execInfo, List<Page> finalResults) {
        if (finalResults.stream().anyMatch(p -> p.getPositionCount() > 0)) {
            return;
        }
        int totalFailedShards = 0;
        for (EsqlExecutionInfo.Cluster cluster : execInfo.clusterInfo.values()) {
            Integer successfulShards = cluster.getSuccessfulShards();
            if (successfulShards != null && successfulShards > 0) {
                return;
            }
            if (cluster.getFailedShards() == null) continue;
            totalFailedShards += cluster.getFailedShards().intValue();
        }
        if (totalFailedShards == 0) {
            return;
        }
        FailureCollector failureCollector = new FailureCollector();
        for (EsqlExecutionInfo.Cluster cluster : execInfo.clusterInfo.values()) {
            Integer failedShards = cluster.getFailedShards();
            if (failedShards == null || failedShards <= 0) continue;
            assert (!cluster.getFailures().isEmpty()) : "expected failures for cluster [" + cluster.getClusterAlias() + "]";
            for (ShardSearchFailure failure : cluster.getFailures()) {
                Throwable throwable = failure.getCause();
                if (throwable instanceof Exception) {
                    Exception e = (Exception)throwable;
                    failureCollector.unwrapAndCollect(e);
                    continue;
                }
                assert (false) : "unexpected failure: " + String.valueOf(new AssertionError((Object)failure.getCause()));
                failureCollector.unwrapAndCollect((Exception)failure);
            }
        }
        ExceptionsHelper.reThrowIfNotNull((Throwable)failureCollector.getFailure());
    }

    void runCompute(CancellableTask task, ComputeContext context, PhysicalPlan plan, PlanTimeProfile planTimeProfile, ActionListener<DriverCompletionInfo> listener) {
        IndexedByShardId shardContexts = context.searchContexts().map(ComputeSearchContext::shardContext);
        EsPhysicalOperationProviders physicalOperationProviders = new EsPhysicalOperationProviders(context.foldCtx(), (IndexedByShardId<? extends EsPhysicalOperationProviders.ShardContext>)shardContexts, this.searchService.getIndicesService().getAnalysis(), this.plannerSettings);
        try {
            LocalExecutionPlanner planner = new LocalExecutionPlanner(context.sessionId(), context.clusterAlias(), task, this.bigArrays, this.blockFactory, this.clusterService.getSettings(), context.configuration(), context.exchangeSourceSupplier(), context.exchangeSinkSupplier(), this.enrichLookupService, this.lookupFromIndexService, this.inferenceService, physicalOperationProviders);
            LOGGER.debug("Received physical plan for {}:\n{}", new Object[]{context.description(), plan});
            PhysicalPlan localPlan = PlannerUtils.localPlan(this.plannerSettings, context.flags(), new ArrayList<SearchExecutionContext>(context.searchExecutionContexts().collection()), context.configuration(), context.foldCtx(), plan, planTimeProfile);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Local plan for {}:\n{}", new Object[]{context.description(), localPlan});
            }
            LocalExecutionPlanner.LocalExecutionPlan localExecutionPlan = planner.plan(context.description(), context.foldCtx(), this.plannerSettings, localPlan, (IndexedByShardId<? extends EsPhysicalOperationProviders.ShardContext>)shardContexts);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Local execution plan for {}:\n{}", new Object[]{context.description(), localExecutionPlan.describe()});
            }
            List<Driver> drivers = localExecutionPlan.createDrivers(context.sessionId());
            if (context.description().equals(DATA_DESCRIPTION)) {
                shardContexts.collection().forEach(RefCounted::decRef);
            }
            if (drivers.isEmpty()) {
                throw new IllegalStateException("no drivers created");
            }
            LOGGER.debug("using {} drivers", new Object[]{drivers.size()});
            ActionListener<Void> driverListener = this.addCompletionInfo(listener, drivers, context, localPlan, planTimeProfile);
            this.driverRunner.executeDrivers((Task)task, drivers, (Executor)this.transportService.getThreadPool().executor("esql_worker"), ActionListener.releaseAfter(driverListener, () -> Releasables.close((Iterable)drivers)));
        }
        catch (Exception e) {
            Releasables.close((Iterable)context.searchContexts().collection());
            LOGGER.debug("Error in ComputeService.runCompute for : " + context.description());
            listener.onFailure(e);
        }
    }

    ActionListener<Void> addCompletionInfo(ActionListener<DriverCompletionInfo> listener, List<Driver> drivers, ComputeContext context, PhysicalPlan localPlan, PlanTimeProfile planTimeProfile) {
        boolean needPlanString = LOGGER.isDebugEnabled() || context.configuration().profile();
        String planString = needPlanString ? localPlan.toString() : null;
        return listener.map(ignored -> {
            if (LOGGER.isDebugEnabled() || context.configuration().profile()) {
                DriverCompletionInfo driverCompletionInfo = DriverCompletionInfo.includingProfiles((List)drivers, (String)context.description(), (String)this.clusterService.getClusterName().value(), (String)this.transportService.getLocalNode().getName(), (String)planString, (PlanTimeProfile)planTimeProfile);
                LOGGER.debug("finished {}", new Object[]{driverCompletionInfo});
                if (context.configuration().profile()) {
                    return driverCompletionInfo;
                }
            }
            return DriverCompletionInfo.excludingProfiles((List)drivers);
        });
    }

    static ReductionPlan reductionPlan(PlannerSettings plannerSettings, EsqlFlags flags, Configuration configuration, FoldContext foldCtx, ExchangeSinkExec originalPlan, boolean runNodeLevelReduction, boolean reduceNodeLateMaterialization, PlanTimeProfile planTimeProfile) {
        ReductionPlan reductionPlan;
        long startTime = planTimeProfile == null ? 0L : System.nanoTime();
        ExchangeSourceExec source = new ExchangeSourceExec(originalPlan.source(), originalPlan.output(), originalPlan.isIntermediateAgg());
        ReductionPlan defaultResult = new ReductionPlan(originalPlan.replaceChild(source), originalPlan);
        if (!reduceNodeLateMaterialization && !runNodeLevelReduction) {
            return defaultResult;
        }
        Function<PhysicalPlan, ReductionPlan> placePlanBetweenExchanges = p -> new ReductionPlan(originalPlan.replaceChild(p.replaceChildren(List.of(source))), originalPlan);
        PlannerUtils.PlanReduction planReduction = PlannerUtils.reductionPlan(originalPlan);
        Objects.requireNonNull(planReduction);
        PlannerUtils.PlanReduction planReduction2 = planReduction;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PlannerUtils.TopNReduction.class, PlannerUtils.TopNReduction.class, PlannerUtils.ReducedPlan.class}, (Object)planReduction2, n)) {
                case 0: {
                    PlannerUtils.TopNReduction topN = (PlannerUtils.TopNReduction)planReduction2;
                    if (!reduceNodeLateMaterialization) {
                        n = 1;
                        continue block5;
                    }
                    reductionPlan = LateMaterializationPlanner.planReduceDriverTopN(stats -> new LocalPhysicalOptimizerContext(plannerSettings, flags, configuration, foldCtx, (SearchStats)stats), originalPlan).orElseGet(() -> runNodeLevelReduction ? (ReductionPlan)placePlanBetweenExchanges.apply(topN.plan()) : defaultResult);
                    break block5;
                }
                case 1: {
                    PlannerUtils.TopNReduction topN = (PlannerUtils.TopNReduction)planReduction2;
                    if (!runNodeLevelReduction) {
                        n = 2;
                        continue block5;
                    }
                    reductionPlan = placePlanBetweenExchanges.apply(topN.plan());
                    break block5;
                }
                case 2: {
                    PlannerUtils.ReducedPlan rp = (PlannerUtils.ReducedPlan)planReduction2;
                    if (!runNodeLevelReduction) {
                        n = 3;
                        continue block5;
                    }
                    reductionPlan = placePlanBetweenExchanges.apply(rp.plan());
                    break block5;
                }
                default: {
                    reductionPlan = defaultResult;
                    break block5;
                }
            }
            break;
        }
        ReductionPlan reductionPlan2 = reductionPlan;
        if (planTimeProfile != null) {
            planTimeProfile.addReductionPlanNanos(System.nanoTime() - startTime);
        }
        return reductionPlan2;
    }

    String newChildSession(String session) {
        return session + "/" + this.childSessionIdGenerator.incrementAndGet();
    }

    String profileDescription(String qualifier, String label) {
        return qualifier == null ? label : qualifier + "." + label;
    }

    Runnable cancelQueryOnFailure(CancellableTask task) {
        return new RunOnce(() -> {
            LOGGER.debug("cancelling ESQL task {} on failure", new Object[]{task});
            this.transportService.getTaskManager().cancelTaskAndDescendants(task, "cancelled on failure", false, ActionListener.noop());
        });
    }

    CancellableTask createGroupTask(Task parentTask, Supplier<String> description) throws TaskCancelledException {
        TaskManager taskManager = this.transportService.getTaskManager();
        try (ThreadContext.StoredContext ignored = this.transportService.getThreadPool().getThreadContext().newTraceContext();){
            CancellableTask cancellableTask = (CancellableTask)taskManager.register("transport", "esql_compute_group", (TaskAwareRequest)new ComputeGroupTaskRequest(parentTask.taskInfo(this.transportService.getLocalNode().getId(), false).taskId(), description));
            return cancellableTask;
        }
    }

    public EsqlFlags createFlags() {
        return new EsqlFlags(this.clusterService.getClusterSettings());
    }

    private static Map<String, OriginalIndices> getIndices(PhysicalPlan plan, Function<EsRelation, Map<String, List<String>>> getter) {
        Holder holder = new Holder();
        PlannerUtils.forEachRelation(plan, esRelation -> holder.set((Object)Maps.transformValues((Map)((Map)getter.apply((EsRelation)esRelation)), v -> new OriginalIndices((String[])v.toArray(String[]::new), SearchRequest.DEFAULT_INDICES_OPTIONS))));
        return (Map)holder.getOrDefault(Map::of);
    }

    private static class ComputeGroupTaskRequest
    extends AbstractTransportRequest {
        private final Supplier<String> parentDescription;

        ComputeGroupTaskRequest(TaskId parentTask, Supplier<String> description) {
            this.parentDescription = description;
            this.setParentTask(parentTask);
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            assert (parentTaskId.isSet());
            return new CancellableTask(id, type, action, ComputeService.LOCAL_CLUSTER, parentTaskId, headers);
        }

        public String getDescription() {
            return "group [" + this.parentDescription.get() + "]";
        }
    }
}

