/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.planner.mapper;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorMode;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.BinaryPlan;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.Filter;
import org.elasticsearch.xpack.esql.plan.logical.LeafPlan;
import org.elasticsearch.xpack.esql.plan.logical.Limit;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.TopN;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.plan.logical.join.Join;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinConfig;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinTypes;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalRelation;
import org.elasticsearch.xpack.esql.plan.physical.EsSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.FragmentExec;
import org.elasticsearch.xpack.esql.plan.physical.HashJoinExec;
import org.elasticsearch.xpack.esql.plan.physical.LimitExec;
import org.elasticsearch.xpack.esql.plan.physical.LocalSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.LookupJoinExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.TopNExec;
import org.elasticsearch.xpack.esql.planner.mapper.MapperUtils;

public class LocalMapper {
    public static LocalMapper INSTANCE = new LocalMapper();

    private LocalMapper() {
    }

    public PhysicalPlan map(LogicalPlan p) {
        if (p instanceof LeafPlan) {
            LeafPlan leaf = (LeafPlan)p;
            return this.mapLeaf(leaf);
        }
        if (p instanceof UnaryPlan) {
            UnaryPlan unary = (UnaryPlan)p;
            return this.mapUnary(unary);
        }
        if (p instanceof BinaryPlan) {
            BinaryPlan binary = (BinaryPlan)p;
            return this.mapBinary(binary);
        }
        return MapperUtils.unsupported(p);
    }

    private PhysicalPlan mapLeaf(LeafPlan leaf) {
        if (leaf instanceof EsRelation) {
            EsRelation esRelation = (EsRelation)leaf;
            return new EsSourceExec(esRelation);
        }
        return MapperUtils.mapLeaf(leaf);
    }

    private PhysicalPlan mapUnary(UnaryPlan unary) {
        PhysicalPlan mappedChild = this.map(unary.child());
        if (unary instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)unary;
            List<Attribute> intermediate = MapperUtils.intermediateAttributes(aggregate);
            return MapperUtils.aggExec(aggregate, mappedChild, AggregatorMode.INITIAL, intermediate);
        }
        if (unary instanceof Limit) {
            Limit limit = (Limit)unary;
            return new LimitExec(limit.source(), mappedChild, limit.limit(), null);
        }
        if (unary instanceof TopN) {
            TopN topN = (TopN)unary;
            return new TopNExec(topN.source(), mappedChild, topN.order(), topN.limit(), null);
        }
        return MapperUtils.mapUnary(unary, mappedChild);
    }

    private PhysicalPlan mapBinary(BinaryPlan binary) {
        if (binary instanceof Join) {
            Join join = (Join)binary;
            JoinConfig config = join.config();
            if (config.type() != JoinTypes.LEFT) {
                throw new EsqlIllegalArgumentException("unsupported join type [" + String.valueOf(config.type()) + "]");
            }
            PhysicalPlan left = this.map(binary.left());
            if (binary.right() instanceof LocalRelation) {
                PhysicalPlan right = this.map(binary.right());
                if (right instanceof LocalSourceExec) {
                    LocalSourceExec localData = (LocalSourceExec)right;
                    return new HashJoinExec(join.source(), left, localData, config.leftFields(), config.rightFields(), join.rightOutputFields());
                }
                throw new EsqlIllegalArgumentException("Unsupported right plan for join [" + binary.right().nodeName() + "]");
            }
            EsRelation rightRelation = null;
            LogicalPlan logicalPlan = binary.right();
            if (logicalPlan instanceof EsRelation) {
                EsRelation esRelation;
                rightRelation = esRelation = (EsRelation)logicalPlan;
            } else {
                Filter filter;
                logicalPlan = binary.right();
                if (logicalPlan instanceof Filter && (logicalPlan = (filter = (Filter)logicalPlan).child()) instanceof EsRelation) {
                    EsRelation esRelation;
                    rightRelation = esRelation = (EsRelation)logicalPlan;
                }
            }
            if (rightRelation == null) {
                throw new EsqlIllegalArgumentException("Unsupported right plan for lookup join [" + binary.right().nodeName() + "]");
            }
            if (rightRelation.indexMode() != IndexMode.LOOKUP) {
                throw new EsqlIllegalArgumentException("To perform a lookup join with index [" + rightRelation.indexPattern() + "], it must be a in lookup index mode");
            }
            FragmentExec fragmentExec = new FragmentExec(binary.right());
            return new LookupJoinExec(join.source(), left, fragmentExec, config.leftFields(), config.rightFields(), join.rightOutputFields(), config.joinOnConditions());
        }
        return MapperUtils.unsupported(binary);
    }
}

