/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.planner;

import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.core.QlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.MetadataAttribute;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.querydsl.query.SingleValueQuery;

public final class TranslatorHandler {
    public static final TranslatorHandler TRANSLATOR_HANDLER = new TranslatorHandler();

    private TranslatorHandler() {
    }

    public Query asQuery(LucenePushdownPredicates predicates, Expression e) {
        if (e instanceof TranslationAware) {
            Query query;
            TranslationAware ta = (TranslationAware)((Object)e);
            Query query2 = ta.asQuery(predicates, this);
            if (ta instanceof TranslationAware.SingleValueTranslationAware) {
                TranslationAware.SingleValueTranslationAware sv = (TranslationAware.SingleValueTranslationAware)ta;
                query = TranslatorHandler.wrapFunctionQuery(sv.singleValueField(), query2);
            } else {
                query = query2;
            }
            return query;
        }
        throw new QlIllegalArgumentException("Don't know how to translate {} {}", new Object[]{e.nodeName(), e});
    }

    private static Query wrapFunctionQuery(Expression field, Query query) {
        if (query instanceof SingleValueQuery) {
            return query;
        }
        if (field instanceof FieldAttribute) {
            FieldAttribute fa = (FieldAttribute)field;
            fa = fa.getExactInfo().hasExact() ? fa.exactAttribute() : fa;
            return new SingleValueQuery(query, fa.name(), false);
        }
        if (field instanceof MetadataAttribute) {
            return query;
        }
        throw new EsqlIllegalArgumentException("Expected a FieldAttribute or MetadataAttribute but received [" + String.valueOf(field) + "]");
    }

    public String nameOf(Expression e) {
        return Expressions.name(e);
    }
}

